<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Top Up Credits') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8"> {{-- Matched max-width from deposit form --}}
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-6 lg:p-8"> {{-- Removed border class, matched deposit form --}}
                    <h3 class="text-2xl font-semibold text-gray-900 dark:text-gray-100 mb-6">
                        {{ __('Purchase Credits') }}
                    </h3>

                    @include('layouts.partials.flash-messages') {{-- Using flash-messages partial like deposit form --}}

                    <div class="mb-6 p-4 border border-blue-200 dark:border-blue-700 bg-blue-50 dark:bg-gray-700/50 rounded-md">
                        <p class="text-sm text-gray-700 dark:text-gray-300">
                            {{ __('Your Current Credit Balance') }}
                        </h3>
                        <p class="mt-1 text-3xl font-semibold text-gray-700 dark:text-gray-300">
                            {{ number_format($currentCreditBalance) }} {{ __('Credits') }}
                        </p>
                    </div>

                    <form method="POST" action="{{ route('user.credits.topup.process') }}">
                        @csrf

                        <div class="mb-4"> {{-- Matched class from deposit form --}}
                            <label for="credits" class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('Number of Credits to Purchase') }}</label>
                            <input id="credits" class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:bg-gray-700 dark:text-gray-200" type="number" name="credits" value="{{ old('credits', setting('credits_min_purchase_amount', 10)) }}" required autofocus min="{{ setting('credits_min_purchase_amount', 1) }}" />
                            @error('credits') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            {{-- You might want to display price per credit or package deals here --}}
                            {{-- <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">Price: ${{ number_format(setting('price_per_credit', 0.10), 2) }} per credit.</p> --}}
                        </div>

                        <div class="mb-6"> {{-- Uncommented and matched class from deposit form --}}
                            <label for="payment_method" class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ __('Select Payment Method') }}</label>
                            @if(!empty($paymentGateways))
                                <select name="payment_method" id="payment_method" required class="block mt-1 w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                                    @foreach($paymentGateways as $key => $gateway)
                                        <option value="{{ $gateway['key'] }}" {{ old('payment_method') == $gateway['key'] ? 'selected' : '' }}>
                                            {{ $gateway['name'] }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('payment_method') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            @else
                                <p class="mt-1 text-center text-red-500 dark:text-red-400">
                                    {{ __('No payment methods are currently available for credit purchases.') }}
                                </p>
                            @endif
                        </div>

                        {{-- Placeholder for payment gateway specific fields (e.g., Stripe Elements, PayPal button) --}}
                        <div id="payment-element-container" class="my-4">
                            {{-- Specific gateway JS might populate this, or it can be left empty if not needed for credit purchases --}}
                        </div>

                        <div class="flex items-center justify-end mt-8">
                            <button type="submit" class="w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-3 px-4 rounded-lg text-center transition duration-150 ease-in-out" @if(empty($paymentGateways)) disabled @endif>
                                {{ __('Proceed to Payment') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>