<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('My Account Settings') }}
        </h2>
    </x-slot>

    <div>
        <div class="max-w-7xl mx-auto py-10 sm:px-6 lg:px-8">
            <div class="space-y-10">
                @if (Laravel\Fortify\Features::canUpdateProfileInformation())
                    <div class="p-6 bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg">
                        @livewire('profile.update-profile-information-form')
                    </div>
                @endif

                @if (Laravel\Fortify\Features::enabled(Laravel\Fortify\Features::updatePasswords()))
                    <div class="p-6 bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg">
                        @livewire('profile.update-password-form')
                    </div>
                @endif

                @if (Laravel\Fortify\Features::canManageTwoFactorAuthentication())
                    <div class="p-6 bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg">
                        @livewire('profile.two-factor-authentication-form')
                    </div>
                @endif

                <div class="p-6 bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg">
                    @livewire('profile.logout-other-browser-sessions-form')
                </div>

                @if (Laravel\Jetstream\Jetstream::hasAccountDeletionFeatures())
                    <div class="p-6 bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg">
                        @livewire('profile.delete-user-form')
                    </div>
                @endif
            </div>
        </div>
    </div>
</x-app-layout>
