<nav x-data="{ open: false }" class="bg-white dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700">
    <!-- Primary Navigation Menu -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('dashboard') }}">
                        @if(setting('site_logo') && Storage::disk('public')->exists(setting('site_logo')))
                            <img src="{{ Storage::url(setting('site_logo')) }}" alt="{{ setting('site_name', config('app.name', 'Laravel')) }}" class="block h-9 w-auto">
                        @else
                            <x-application-mark class="block h-9 w-auto" />
                        @endif
                    </a>
                    <span class="ml-3 font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight hidden sm:block">{{ setting('site_name', config('app.name', 'Laravel')) }}</span>
                </div>

                <!-- Navigation Links -->
                <div class="hidden space-x-8 sm:-my-px sm:ml-10 sm:flex">
                    <x-nav-link href="{{ route('dashboard') }}" :active="request()->routeIs('dashboard')">
                        {{ __('Dashboard') }}
                    </x-nav-link>
                    @if(function_exists('setting') && setting('subscriptions_enabled', '0') == '1')
                        <x-nav-link href="{{ route('subscription.plans') }}" :active="request()->routeIs('subscription.plans')">
                            {{ __('Pricing') }} {{-- Or 'Subscription Plans' --}}
                        </x-nav-link>
                    @endif

                    {{-- Add other user-facing navigation links here if needed --}}
                </div>
            </div>

            <div class="hidden sm:flex sm:items-center sm:ml-6">
                <!-- Notifications Dropdown -->
                @auth
                    <div class="ml-3 relative">
                        <x-dropdown align="right" width="60"> {{-- Increased width for notifications --}}
                            <x-slot name="trigger">
                                <button class="relative inline-flex items-center p-2 border-2 border-transparent rounded-full text-gray-400 hover:text-gray-500 focus:outline-none focus:text-gray-500 focus:border-gray-300 transition">
                                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                                    </svg>
                                    @if($unreadNotificationsCount > 0)
                                        <span class="absolute top-0 right-0 block h-2 w-2 transform translate-x-1/2 -translate-y-1/2 bg-red-600 rounded-full"></span>
                                    @endif
                                </button>
                            </x-slot>

                            <x-slot name="content">
                                <div class="block px-4 py-2 text-xs text-gray-400">
                                    Notifications
                                    @if($unreadNotificationsCount > 0)
                                        <span class="ml-1 text-red-500">({{ $unreadNotificationsCount }} new)</span>
                                    @endif
                                </div>

                                @if($recentNotifications->isEmpty())
                                    <div class="px-4 py-3 text-sm text-gray-500">
                                        No new notifications.
                                    </div>
                                @else
                                    @foreach($recentNotifications as $notification)
                                        <x-dropdown-link href="{{ route('frontend.notifications.readAndRedirect', $notification->id) }}" class="{{ $notification->read_at ? '' : 'bg-gray-100 dark:bg-gray-700' }}">
                                            <div class="text-sm">
                                                <p class="text-gray-700 dark:text-gray-200 truncate">{{ $notification->data['message'] ?? 'Notification' }}</p>
                                                <p class="text-xs text-gray-500 dark:text-gray-400">{{ $notification->created_at->diffForHumans() }}</p>
                                            </div>
                                        </x-dropdown-link>
                                    @endforeach
                                @endif

                                <div class="border-t border-gray-200 dark:border-gray-600"></div>
                                {{-- Link to a full notifications page --}}
                                @if(Route::has('frontend.notifications.index')) {{-- Ensure this route exists --}}
                                    <x-dropdown-link href="{{ route('frontend.notifications.index') }}">
                                        View All Notifications
                                    </x-dropdown-link>
                                @endif
                            </x-slot>
                        </x-dropdown>
                    </div>
                @endauth

                <!-- Teams Dropdown -->
                @if (Laravel\Jetstream\Jetstream::hasTeamFeatures() && Auth::user())
                    <div class="ml-3 relative">
                        <x-dropdown align="right" width="60">
                            <x-slot name="trigger">
                                <span class="inline-flex rounded-md">
                                    <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 dark:text-gray-400 bg-white dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none focus:bg-gray-50 dark:focus:bg-gray-700 active:bg-gray-50 dark:active:bg-gray-700 transition ease-in-out duration-150">
                                        @php $currentTeam = Auth::user()->currentTeam()->first(); @endphp
                                        @if ($currentTeam)
                                            {{ $currentTeam->name }}
                                        @else
                                            {{-- Fallback text if no current team is set or found --}}
                                            {{ __('Select Team') }}
                                        @endif
                                        <svg class="ml-2 -mr-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 15L12 18.75 15.75 15m-7.5-6L12 5.25 15.75 9" />
                                        </svg>
                                    </button>
                                </span>
                            </x-slot>

                            <x-slot name="content">
                                <div class="w-60">
                                    <!-- Team Management -->
                                    <div class="block px-4 py-2 text-xs text-gray-400">
                                        {{ __('Manage Team') }}
                                    </div>

                                    <!-- Team Settings -->
                                    @if ($currentTeam && Route::has('teams.show'))
                                        <x-dropdown-link href="{{ route('teams.show', $currentTeam->id) }}">
                                            {{ __('Team Settings') }}
                                        </x-dropdown-link>
                                    @elseif (Auth::user()->currentTeam)
                                        {{-- Log or display a less critical error if route is missing but team exists --}}
                                        {{-- <span class="block px-4 py-2 text-xs text-red-400">Team settings link unavailable.</span> --}}
                                    @endif

                                    @can('create', Laravel\Jetstream\Jetstream::newTeamModel())
                                        @if (Route::has('teams.create'))
                                            <x-dropdown-link href="{{ route('teams.create') }}">
                                                {{ __('Create New Team') }}
                                            </x-dropdown-link>
                                        @endif
                                    @endcan

                                    <!-- Team Switcher -->
                                    @if (Auth::user()->allTeams()->count() > 1)
                                        <div class="border-t border-gray-200 dark:border-gray-700"></div>

                                        <div class="block px-4 py-2 text-xs text-gray-400">
                                            {{ __('Switch Teams') }}
                                        </div>

                                        @foreach (Auth::user()->allTeams() as $team)
                                            <x-switchable-team :team="$team" />
                                        @endforeach
                                    @endif
                                </div>
                            </x-slot>
                        </x-dropdown>
                    </div>
                @endif

                <!-- Settings Dropdown -->
                @auth
                <div class="ml-3 relative">
                    <x-dropdown align="right" width="48">
                        <x-slot name="trigger">
                            @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                                <button class="flex text-sm border-2 border-transparent rounded-full focus:outline-none focus:border-gray-300 dark:focus:border-gray-500 transition">
                                    <img class="h-8 w-8 rounded-full object-cover" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />
                                </button>
                            @else
                                <span class="inline-flex rounded-md">
                                    <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 dark:text-gray-400 bg-white dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none focus:bg-gray-50 dark:focus:bg-gray-700 active:bg-gray-50 dark:active:bg-gray-700 transition ease-in-out duration-150">
                                        {{ Auth::user()->name }}

                                        <svg class="ml-2 -mr-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 8.25l-7.5 7.5-7.5-7.5" />
                                        </svg>
                                    </button>
                                </span>
                            @endif
                        </x-slot>

                        <x-slot name="content">
                            <!-- Account Management -->
                            <div class="block px-4 py-2 text-xs text-gray-400">
                                {{ __('Manage Account') }}
                            </div>

                            <x-dropdown-link href="{{ route('profile.show') }}">
                                {{ __('Profile') }}
                            </x-dropdown-link>

                            @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                                <x-dropdown-link href="{{ route('api-tokens.index') }}">
                                    {{ __('API Tokens') }}
                                </x-dropdown-link>
                            @endif

                            <div class="border-t border-gray-200 dark:border-gray-600"></div>

                            <!-- Admin Panel Link -->
                            @if (Auth::user() && Auth::user()->isAdmin())
                                <x-dropdown-link href="{{ route('admin.dashboard') }}">
                                    {{ __('Admin Panel') }}
                                </x-dropdown-link>
                                <div class="border-t border-gray-200 dark:border-gray-600"></div>
                            @endif


                            <!-- Authentication -->
                            <form method="POST" action="{{ route('logout') }}" x-data>
                                @csrf

                                <x-dropdown-link href="{{ route('logout') }}"
                                         @click.prevent="$root.submit();">
                                    {{ __('Log Out') }}
                                </x-dropdown-link>
                            </form>
                        </x-slot>
                    </x-dropdown>
                </div>
                @endauth
            </div>

            <!-- Hamburger -->
            <div class="-mr-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-900 focus:text-gray-500 dark:focus:text-gray-400 transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link href="{{ route('dashboard') }}" :active="request()->routeIs('dashboard')">
                {{ __('Dashboard') }}
            </x-responsive-nav-link>
            @if(function_exists('setting') && setting('subscriptions_enabled', '0') == '1')
                <x-responsive-nav-link href="{{ route('subscription.plans') }}" :active="request()->routeIs('subscription.plans') || request()->routeIs('subscription.checkout')">
                    {{ __('Pricing') }}
                </x-responsive-nav-link>
            @endif
        </div>

        <!-- Responsive Settings Options -->
        @auth
        <div class="pt-4 pb-1 border-t border-gray-200 dark:border-gray-600">
            <div class="flex items-center px-4">
                @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                    <div class="shrink-0 mr-3">
                        <img class="h-10 w-10 rounded-full object-cover" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />
                    </div>
                @endif

                <div>
                    <div class="font-medium text-base text-gray-800 dark:text-gray-200">{{ Auth::user()->name }}</div>
                    <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
                </div>
            </div>

            <div class="mt-3 space-y-1">
                {{-- Wallet Links for Responsive Menu --}}
                @if(function_exists('setting') && setting('wallet_system_enabled', '0') == '1')
                    @php $isWalletActiveResponsive = request()->routeIs('user.wallet.*'); @endphp
                    <div x-data="{ open: {{ $isWalletActiveResponsive ? 'true' : 'false' }} }" class="border-t border-gray-200 dark:border-gray-600">
                        <div @click="open = !open" class="flex items-center justify-between w-full px-4 py-2 text-left text-sm font-medium text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:bg-gray-50 dark:focus:bg-gray-700 cursor-pointer">
                            <span class="flex items-center">
                                <x-heroicon-o-wallet class="w-5 h-5 mr-2" />
                                {{ __('My Wallet') }}
                            </span>
                            <svg class="w-4 h-4 transform transition-transform duration-200" :class="{'rotate-90': open, 'rotate-0': !open}" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div x-show="open" x-transition class="mt-1 space-y-1 pl-4">
                            @if(function_exists('setting') && setting('allow_wallet_deposits', '0') == '1' && Route::has('user.wallet.deposit.form'))
                                <x-responsive-nav-link href="{{ route('user.wallet.deposit.form') }}" :active="request()->routeIs('user.wallet.deposit.form')">
                                    {{ __('Deposit Funds') }}
                                </x-responsive-nav-link>
                            @endif
                            @if(function_exists('setting') && setting('allow_wallet_withdrawals', '0') == '1' && Route::has('user.wallet.withdraw.form'))
                                <x-responsive-nav-link href="{{ route('user.wallet.withdraw.form') }}" :active="request()->routeIs('user.wallet.withdraw.form')">
                                    {{ __('Request Withdrawal') }}
                                </x-responsive-nav-link>
                            @endif
                            @if(Route::has('user.wallet.history'))
                            <x-responsive-nav-link href="{{ route('user.wallet.history') }}" :active="request()->routeIs('user.wallet.history')">
                                {{ __('Transaction History') }}
                            </x-responsive-nav-link>
                            @endif
                        </div>
                    </div>
                @endif

                {{-- Credits Links for Responsive Menu --}}
                @if(function_exists('setting') && setting('credits_system_enabled', '0') == '1')
                    @php $isCreditsActiveResponsive = request()->routeIs('user.credits.*'); @endphp
                    <div x-data="{ open: {{ $isCreditsActiveResponsive ? 'true' : 'false' }} }" class="border-t border-gray-200 dark:border-gray-600">
                         <div @click="open = !open" class="flex items-center justify-between w-full px-4 py-2 text-left text-sm font-medium text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:bg-gray-50 dark:focus:bg-gray-700 cursor-pointer">
                            <span class="flex items-center">
                                <x-heroicon-o-sparkles class="w-5 h-5 mr-2" />
                                {{ __('My Credits') }}
                            </span>
                            <svg class="w-4 h-4 transform transition-transform duration-200" :class="{'rotate-90': open, 'rotate-0': !open}" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div x-show="open" x-transition class="mt-1 space-y-1 pl-4">
                            @if(Route::has('user.credits.history'))
                            <x-responsive-nav-link href="{{ route('user.credits.history') }}" :active="request()->routeIs('user.credits.history')">
                                {{ __('Transaction History') }}
                            </x-responsive-nav-link>
                            @endif
                            {{-- Top Up Credits link is commented out in sidebar, so keeping it commented here too --}}
                        </div>
                    </div>
                @endif

                {{-- Support Tickets Link for Responsive Menu --}}
                 @if(Route::has('user.tickets.index'))
                <x-responsive-nav-link href="{{ route('user.tickets.index') }}" :active="request()->routeIs('user.tickets.*')">
                     <x-heroicon-o-ticket class="w-5 h-5 mr-2 inline-block" />
                    {{ __('Support Tickets') }}
                </x-responsive-nav-link>
                @endif

                {{-- Dynamic Module Menu Items for Responsive Menu --}}
                @php
                    $responsiveUserMenuItems = [];
                    if (class_exists(Nwidart\Modules\Facades\Module::class)) {
                        $currentUserForResponsiveMenu = Auth::user();

                        foreach (Nwidart\Modules\Facades\Module::allEnabled() as $module) {
                            $moduleUserMenu = $module->get('user_menu');

                            if (is_array($moduleUserMenu)) {
                                foreach ($moduleUserMenu as $item) {
                                    if (isset($item['title'], $item['route_name']) && Route::has($item['route_name'])) {
                                        $canDisplayItem = false;
                                        if (isset($item['associated_feature_key'])) {
                                            $featureKey = $item['associated_feature_key'];
                                            $canDisplayItem = \App\Helpers\SidebarAccessHelper::canDisplayInSidebar($currentUserForResponsiveMenu, $featureKey);
                                        } else {
                                            $canDisplayItem = true;
                                        }

                                        if ($canDisplayItem) {
                                            $responsiveUserMenuItems[] = $item;
                                        }
                                    }
                                }
                            }
                        }
                    }
                @endphp

                @if(!empty($responsiveUserMenuItems))
                    <div class="pt-2 pb-1 border-t border-gray-200 dark:border-gray-600">
                        <div class="block px-4 text-xs text-gray-400">
                            {{ __('Features & Services') }}
                        </div>
                        @foreach($responsiveUserMenuItems as $item)
                            <x-responsive-nav-link href="{{ route($item['route_name']) }}" :active="request()->routeIs($item['route_name'].'*')">
                                @if(isset($item['icon_svg_path']))
                                    <svg class="w-5 h-5 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $item['icon_svg_path'] }}"></path></svg>
                                @else
                                    <x-heroicon-o-puzzle-piece class="w-5 h-5 mr-2 inline-block" />
                                @endif
                                {{ $item['title'] }}
                            </x-responsive-nav-link>
                        @endforeach
                    </div>
                @endif

                <!-- Account Management -->
                <div class="border-t border-gray-200 dark:border-gray-600">
                    <x-responsive-nav-link href="{{ route('profile.show') }}" :active="request()->routeIs('profile.show')">
                        <x-heroicon-o-user-circle class="w-5 h-5 mr-2 inline-block" />
                        {{ __('Profile') }}
                    </x-responsive-nav-link>

                    @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                        <x-responsive-nav-link href="{{ route('api-tokens.index') }}" :active="request()->routeIs('api-tokens.index')">
                             <x-heroicon-o-key class="w-5 h-5 mr-2 inline-block" />
                            {{ __('API Tokens') }}
                        </x-responsive-nav-link>
                    @endif
                </div>


                <!-- Admin Panel Link -->
                @if (Auth::user() && Auth::user()->isAdmin())
                    <div class="border-t border-gray-200 dark:border-gray-600">
                        <x-responsive-nav-link href="{{ route('admin.dashboard') }}">
                            <x-heroicon-o-chart-bar class="w-5 h-5 mr-2 inline-block" />
                            {{ __('Admin Panel') }}
                        </x-responsive-nav-link>
                    </div>
                @endif

                <!-- Authentication -->
                <div class="border-t border-gray-200 dark:border-gray-600">
                    <form method="POST" action="{{ route('logout') }}" x-data>
                        @csrf
                        <x-responsive-nav-link href="{{ route('logout') }}"
                                       @click.prevent="$root.submit();">
                            <x-heroicon-o-arrow-left-on-rectangle class="w-5 h-5 mr-2 inline-block" />
                            {{ __('Log Out') }}
                        </x-responsive-nav-link>
                    </form>
                </div>


                <!-- Team Management -->
                @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())
                    @php
                        $isTeamsActiveResponsive = request()->routeIs('teams.show') || request()->routeIs('teams.create');
                        $currentTeamResponsive = Auth::user()->currentTeam;
                    @endphp
                    <div x-data="{ open: {{ $isTeamsActiveResponsive ? 'true' : 'false' }} }" class="border-t border-gray-200 dark:border-gray-600">
                        <div @click="open = !open" class="flex items-center justify-between w-full px-4 py-2 text-left text-sm font-medium text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:bg-gray-50 dark:focus:bg-gray-700 cursor-pointer">
                            <span class="flex items-center">
                                <x-heroicon-o-users class="w-5 h-5 mr-2" />
                                {{ __('Manage Team') }}
                            </span>
                             <svg class="w-4 h-4 transform transition-transform duration-200" :class="{'rotate-90': open, 'rotate-0': !open}" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                            </svg>
                        </div>

                        <div x-show="open" x-transition class="mt-1 space-y-1 pl-4">
                            <!-- Team Settings -->
                            @if ($currentTeamResponsive && Route::has('teams.show'))
                                <x-responsive-nav-link href="{{ route('teams.show', $currentTeamResponsive->id) }}" :active="request()->routeIs('teams.show')">
                                    {{ __('Team Settings') }}
                                </x-responsive-nav-link>
                            @endif

                            @can('create', Laravel\Jetstream\Jetstream::newTeamModel())
                                @if (Route::has('teams.create'))
                                    <x-responsive-nav-link href="{{ route('teams.create') }}" :active="request()->routeIs('teams.create')">
                                        {{ __('Create New Team') }}
                                    </x-responsive-nav-link>
                                @endif
                            @endcan

                            <!-- Team Switcher -->
                            @if (Auth::user()->allTeams()->count() > 1)
                                <div class="border-t border-gray-200 dark:border-gray-600 my-1"></div>
                                <div class="block px-4 py-2 text-xs text-gray-400">
                                    {{ __('Switch Teams') }}
                                </div>
                                @foreach (Auth::user()->allTeams() as $team)
                                    <x-switchable-team :team="$team" component="responsive-nav-link" />
                                @endforeach
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        </div>
        @endauth
    </div>
</nav>
