{{-- Sidebar is hidden on mobile (screens smaller than sm), and displayed as a flex column on sm screens and up --}}
<aside class="hidden sm:flex flex-col bg-blue-700 dark:bg-blue-800 text-blue-100 w-64 p-4 sm:p-6 flex-shrink-0">
    <nav class="space-y-1">
        <a href="{{ route('dashboard') }}"
           class="flex items-center py-2.5 px-4 my-1 rounded transition duration-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white {{ request()->routeIs('dashboard') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : '' }}">
            <x-heroicon-o-home class="w-5 h-5 mr-2" />
            {{ __('Dashboard') }}
        </a>

        <a href="{{ route('profile.show') }}"
           class="flex items-center py-2.5 px-4 my-1 rounded transition duration-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white {{ request()->routeIs('profile.show') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : '' }}">
            <x-heroicon-o-user-circle class="w-5 h-5 mr-2" />
            {{ __('My Profile') }}
        </a>

        @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())
        @php 
            $isTeamsActive = request()->routeIs('teams.show') || request()->routeIs('teams.create');
            $currentTeam = Auth::user()->currentTeam;
        @endphp
        <div x-data="{ open: {{ $isTeamsActive ? 'true' : 'false' }} }" class="my-1">
            <button @click="open = !open"
                    class="flex items-center justify-between w-full py-2.5 px-4 rounded transition duration-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white {{ $isTeamsActive ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-100' }}">
                <span class="flex items-center">
                    <x-heroicon-o-users class="w-5 h-5 mr-2" /> {{-- Using users icon for teams --}}
                    {{ __('My Teams') }}
                </span>
                <svg class="w-4 h-4 transform transition-transform duration-200 {{ $isTeamsActive ? 'text-white' : 'text-blue-300' }}" :class="{'rotate-90': open}" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                </svg>
            </button>
            <div x-show="open" x-transition class="mt-1 space-y-1 pl-6">
                @if($currentTeam)
                <a href="{{ route('teams.show', $currentTeam->id) }}" class="flex items-center w-full py-2 px-3 rounded transition duration-200 text-sm {{ request()->routeIs('teams.show', $currentTeam->id) ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white' }}">{{ __('Team Settings') }}</a>
                @endif
                <a href="{{ route('teams.create') }}" class="flex items-center w-full py-2 px-3 rounded transition duration-200 text-sm {{ request()->routeIs('teams.create') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white' }}">{{ __('Create New Team') }}</a>
            </div>
        </div>
        @endif

        @if(function_exists('setting') && setting('subscriptions_enabled', '0') == '1')
        <a href="{{ route('subscription.plans') }}"
           class="flex items-center py-2.5 px-4 my-1 rounded transition duration-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white {{ request()->routeIs('subscription.plans') || request()->routeIs('subscription.checkout') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : '' }}">
            <x-heroicon-o-credit-card class="w-5 h-5 mr-2" />
            {{ __('Subscription Plans') }}
        </a>
        @endif

        @if(function_exists('setting') && setting('wallet_system_enabled', '0') == '1')
        @php $isWalletActive = request()->routeIs('user.wallet.*'); @endphp
        <div x-data="{ open: {{ $isWalletActive ? 'true' : 'false' }} }" class="my-1">
            <button @click="open = !open"
                    class="flex items-center justify-between w-full py-2.5 px-4 rounded transition duration-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white {{ $isWalletActive ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-100' }}">
                <span class="flex items-center">
                    <x-heroicon-o-wallet class="w-5 h-5 mr-2" />
                    {{ __('My Wallet') }}
                </span>
                <svg class="w-4 h-4 transform transition-transform duration-200 {{ $isWalletActive ? 'text-white' : 'text-blue-300' }}" :class="{'rotate-90': open}" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                </svg>
            </button>
            <div x-show="open" x-transition class="mt-1 space-y-1 pl-6">
                @if(function_exists('setting') && setting('allow_wallet_deposits', '0') == '1')
                <a href="{{ route('user.wallet.deposit.form') }}"
                   class="flex items-center w-full py-2 px-3 rounded transition duration-200 text-sm {{ request()->routeIs('user.wallet.deposit.form') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white' }}">
                    {{ __('Deposit Funds') }}
                </a>
                @endif
                @if(function_exists('setting') && setting('allow_wallet_withdrawals', '0') == '1')
                <a href="{{ route('user.wallet.withdraw.form') }}"
                   class="flex items-center w-full py-2 px-3 rounded transition duration-200 text-sm {{ request()->routeIs('user.wallet.withdraw.form') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white' }}">
                    {{ __('Request Withdrawal') }}
                </a>
                @endif
                <a href="{{ route('user.wallet.history') }}"
                   class="flex items-center w-full py-2 px-3 rounded transition duration-200 text-sm {{ request()->routeIs('user.wallet.history') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white' }}">
                    {{ __('Transaction History') }}
                </a>
            </div>
        </div>
        @endif

        @if(function_exists('setting') && setting('credits_system_enabled', '0') == '1')
        @php $isCreditsActive = request()->routeIs('user.credits.*'); @endphp
        <div x-data="{ open: {{ $isCreditsActive ? 'true' : 'false' }} }" class="my-1">
            <button @click="open = !open"
                    class="flex items-center justify-between w-full py-2.5 px-4 rounded transition duration-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white {{ $isCreditsActive ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-100' }}">
                <span class="flex items-center">
                    <x-heroicon-o-sparkles class="w-5 h-5 mr-2" />
                    {{ __('My Credits') }}
                </span>
                <svg class="w-4 h-4 transform transition-transform duration-200 {{ $isCreditsActive ? 'text-white' : 'text-blue-300' }}" :class="{'rotate-90': open}" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                </svg>
            </button>
            <div x-show="open" x-transition class="mt-1 space-y-1 pl-6">
                <a href="{{ route('user.credits.history') }}"
                   class="flex items-center w-full py-2 px-3 rounded transition duration-200 text-sm {{ request()->routeIs('user.credits.history') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white' }}">
                    {{ __('Transaction History') }}
                </a>
                {{-- Commenting out the "Top Up Credits" link as per decision to handle credits via subscriptions --}}
                {{--
                @if(function_exists('setting') && setting('allow_credit_purchases', '1') == '1' && Route::has('user.credits.topup.form'))
                <a href="{{ route('user.credits.topup.form') }}"
                   class="flex items-center w-full py-2 px-3 rounded transition duration-200 text-sm {{ request()->routeIs('user.credits.topup.form') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : 'text-blue-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white' }}">
                    {{ __('Top Up Credits') }}
                </a>
                @endif
                --}}
            </div>
        </div>
        @endif

        <a href="{{ route('user.tickets.index') }}"
            class="flex items-center py-2.5 px-4 my-1 rounded transition duration-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white {{ request()->routeIs('user.tickets.*') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : '' }}">
            <x-heroicon-o-ticket class="w-5 h-5 mr-2" />
            {{ __('Support Tickets') }}
        </a>

        @php
            $userMenuItems = [];
            if (class_exists(Nwidart\Modules\Facades\Module::class)) {
                $currentUser = Auth::user();

                foreach (Nwidart\Modules\Facades\Module::allEnabled() as $module) {
                    $moduleUserMenu = $module->get('user_menu');

                    if (is_array($moduleUserMenu)) {
                        foreach ($moduleUserMenu as $item) {
                            if (isset($item['title'], $item['route_name']) && Route::has($item['route_name'])) {
                                $canDisplayItem = false;

                                if (isset($item['associated_feature_key'])) {
                                    $featureKey = $item['associated_feature_key'];
                                    // Use SidebarAccessHelper to determine if this feature-gated item can be displayed
                                    $canDisplayItem = \App\Helpers\SidebarAccessHelper::canDisplayInSidebar($currentUser, $featureKey);
                                } else {
                                    $canDisplayItem = true;
                                }

                                if ($canDisplayItem) {
                                    $userMenuItems[] = $item;
                                }
                            } else {
                                $missingInfo = [];
                                if (!isset($item['title'])) $missingInfo[] = 'title';
                                if (!isset($item['route_name'])) $missingInfo[] = 'route_name';
                                if (isset($item['route_name']) && !Route::has($item['route_name'])) $missingInfo[] = "route '{$item['route_name']}' does not exist";
                            }
                        }
                    }
                }
            }
        @endphp
        @if(!empty($userMenuItems))
            <div class="pt-2 mt-2 border-t border-blue-600 dark:border-blue-700"></div>
            @foreach($userMenuItems as $item)
                <a href="{{ route($item['route_name']) }}"
                   class="flex items-center py-2.5 px-4 my-1 rounded transition duration-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white {{ request()->routeIs($item['route_name'].'*') ? 'bg-blue-800 dark:bg-blue-900 text-white font-semibold' : '' }}">
                    @if(isset($item['icon_svg_path']))
                        <svg class="w-5 h-5 mr-2 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $item['icon_svg_path'] }}"></path></svg>
                    @else
                        <svg class="w-5 h-5 mr-2 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path></svg>
                    @endif
                    {{ $item['title'] }}
                </a>
            @endforeach
        @endif
    </nav>


    @if (Auth::user() && Auth::user()->isAdmin())
        <div class="my-4 border-t border-blue-600 dark:border-blue-700"></div>
            <a href="{{ route('admin.dashboard') }}"
               class="flex items-center py-2.5 px-4 my-2 rounded transition duration-200 hover:bg-blue-600 dark:hover:bg-blue-700 hover:text-white text-sm">
                <x-heroicon-o-chart-bar class="w-5 h-5 mr-2" />
                {{ __('Admin Panel') }}
            </a>
        @endif
</aside>
