<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{
        darkMode: localStorage.getItem('darkMode') === 'true' ||
                  (localStorage.getItem('darkMode') === null && window.matchMedia('(prefers-color-scheme: dark)').matches),
        toggleDarkMode() {
            this.darkMode = !this.darkMode; // The $watch below will handle localStorage
        }
    }"
    x-init="
        $watch('darkMode', val => localStorage.setItem('darkMode', val));
        if (darkMode) document.documentElement.classList.add('dark');
        else document.documentElement.classList.remove('dark');
    "
    :class="{ 'dark': darkMode }">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>@hasSection('title')@yield('title') - {{ setting('site_name', config('app.name', 'DigitalVocano')) }}@else{{ setting('site_name', config('app.name', 'DigitalVocano')) }}@endif</title>
        {{-- Optional: Add meta description and keywords if this layout is used for pages that need them --}}
        {{-- <meta name="description" content="@yield('meta_description', setting('site_description', 'Default description'))"> --}}
        {{-- <meta name="keywords" content="@yield('meta_keywords', setting('site_keywords', 'default,keywords'))"> --}}

        @if(setting('site_favicon'))
        <link rel="icon" href="{{ Storage::url(setting('site_favicon')) }}" type="{{ image_mime_type(Storage::path(setting('site_favicon'))) }}">
        @else
        {{-- Optional: Add a default favicon link here if you have one in public/ --}}
        @endif

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])

        <!-- Styles -->
        @livewireStyles
        @stack('styles') {{-- Added for page-specific styles --}}
        {{-- Removed separate script block for dark mode, handled by x-init --}}
    </head>
    <body class="font-sans antialiased bg-gray-100 dark:bg-gray-900">
        <x-banner />

        @if(session()->has('original_admin_id'))
            <div class="bg-yellow-500 text-white text-center py-2 px-4 fixed top-0 left-0 right-0 z-50">
                <div class="container mx-auto flex justify-between items-center">
                    <span>
                        You are currently logged in as <strong>{{ Auth::user()->name }}</strong> (Impersonating).
                    </span>
                    <a href="{{ route('admin.return-to-admin') }}" class="font-semibold hover:underline">Return to Admin ({{ session('original_admin_name') }})</a>
                </div>
            </div>
        @endif

        {{-- Main layout container --}}
        {{-- Added flex and h-screen to make the sidebar and main content take full height --}}
        <div class="min-h-screen flex flex-col">
            <!-- Top Navigation -->
            @livewire('navigation-menu')

            {{-- Content area below top nav, split into sidebar and main content --}}
            <div class="flex-1 flex flex-col sm:flex-row">
                <!-- User Sidebar -->
                @include('layouts.partials.user-sidebar') {{-- We will create this file next --}}

                <!-- Main Content Area -->
                {{-- flex-1 makes it take up the remaining horizontal space --}}
                <main class="flex-1 flex flex-col overflow-y-auto">
                    <!-- Page Heading -->
                    @if (isset($header))
                        {{-- Sticky header within the main content area. sm:top-auto makes it sticky only on small screens if top nav is also sticky. --}}
                        <header class="bg-white dark:bg-gray-800 shadow sticky top-0 z-10 sm:top-auto">
                            {{-- max-w-full ensures it fills the available width within the main content area --}}
                            <div class="max-w-full mx-auto py-4 px-4 sm:px-6 lg:px-8">
                                {{ $header }}
                            </div>
                        </header>
                    @endif

                    <!-- Page Content -->
                    {{-- sm:ml-64 pushes content right on desktop when sidebar (assumed width-64) is visible --}}
                    <div class="flex-1 p-4 sm:p-6 lg:p-8 sm:ml-64">
                         @include('layouts.partials.flash-messages') {{-- Include flash messages --}}
                        @yield('content')
                        {{ $slot ?? '' }} {{-- Use $slot for Jetstream/Livewire pages, fallback to @yield('content') --}}
                    </div>
                </main>
            </div>
        </div>

        @stack('modals')
        @stack('scripts') {{-- Added for page-specific scripts like the chat widget --}}

        @livewireScripts
    </body>
</html>
