@extends('layouts.app') 

@section('title', 'My Notifications')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-bold text-gray-800 dark:text-white">My Notifications</h1>
        @if(Auth::user()->unreadNotifications->count() > 0)
            <form action="{{ route('frontend.notifications.markAllAsRead') }}" method="POST">
                @csrf
                <button type="submit" class="text-sm text-blue-600 dark:text-blue-400 hover:underline">Mark all as read</button>
            </form>
        @endif
    </div>

    @include('admin.partials.alerts') {{-- Or your frontend alerts partial --}}

    @if($notifications->isEmpty())
        <div class="text-center py-12 bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <p class="text-gray-500 dark:text-gray-400">You have no notifications.</p>
        </div>
    @else
        <div class="bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg overflow-hidden">
            <ul class="divide-y divide-gray-200 dark:divide-gray-700">
                @foreach ($notifications as $notification)
                    <li class="{{ $notification->read_at ? '' : 'bg-blue-50 dark:bg-blue-900/30' }}" id="notification-{{ $notification->id }}">
                        <a href="{{ route('frontend.notifications.readAndRedirect', $notification->id) }}" class="block hover:bg-gray-50 dark:hover:bg-gray-700/50">
                            <div class="px-4 py-4 sm:px-6">
                                <div class="flex items-center justify-between">
                                    <p class="text-sm font-medium text-indigo-600 dark:text-indigo-400 truncate">
                                        {{-- Prioritize specific titles if available, then generic message --}}
                                        {{ $notification->data['tender_title'] ? 'Re: ' . Str::limit($notification->data['tender_title'], 40) : Str::limit($notification->data['message'] ?? 'Notification', 50) }}
                                    </p>
                                    <div class="ml-2 flex-shrink-0 flex">
                                        <p class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $notification->read_at ? 'bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-100' : 'bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100' }}">
                                            {{ $notification->read_at ? 'Read' : 'Unread' }}
                                        </p>
                                    </div>
                                </div>
                                <div class="mt-2 sm:flex sm:justify-between">
                                    <div class="sm:flex">
                                        <p class="flex items-center text-sm text-gray-600 dark:text-gray-300">
                                            {{ $notification->data['message'] ?? 'View details' }}
                                        </p>
                                    </div>
                                    <div class="mt-2 flex items-center text-sm text-gray-500 dark:text-gray-400 sm:mt-0">
                                        <svg class="flex-shrink-0 mr-1.5 h-5 w-5 text-gray-400 dark:text-gray-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd" />
                                        </svg>
                                        <p>
                                            Received: <time datetime="{{ $notification->created_at->toIso8601String() }}">{{ $notification->created_at->format('M d, Y H:i') }}</time>
                                        </p>
                                    </div>
                                </div>
                                @if(!$notification->read_at)
                                <div class="mt-2 text-right">
                                    <form action="{{ route('frontend.notifications.markAsRead', $notification->id) }}" method="POST" class="inline">
                                        @csrf
                                        <button type="submit" class="text-xs text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200">Mark as read</button>
                                    </form>
                                </div>
                                @endif
                            </div>
                        </a>
                    </li>
                @endforeach
            </ul>
            <div class="p-6">
                {{ $notifications->links() }}
            </div>
        </div>
    @endif
</div>
@endsection
