@extends('layouts.frontend')

@section('title', 'Contact Us - ' . setting('site_name', config('app.name')))
@section('meta_description', 'Get in touch with us. We are here to help with your inquiries and support needs.')

@section('content')
<div class="py-12 bg-gray-50 dark:bg-gray-800/50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h1 class="text-4xl font-extrabold text-gray-900 dark:text-white sm:text-5xl">
                Get in Touch
            </h1>
            <p class="mt-4 text-xl text-gray-600 dark:text-gray-300">
                We'd love to hear from you! Whether you have a question, feedback, or need support, feel free to reach out.
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-10 lg:gap-16 items-start">
            {{-- Contact Information Column --}}
            <div class="space-y-8">
                <div class="bg-white dark:bg-gray-800 p-6 rounded-xl shadow-lg">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-100 mb-4">Contact Details</h2>
                    @if($contactEmail)
                    <div class="flex items-center mb-4">
                        <x-heroicon-o-envelope class="w-6 h-6 text-purple-600 dark:text-purple-400 mr-3"/>
                        <div>
                            <h3 class="font-medium text-gray-700 dark:text-gray-200">Email Us</h3>
                            <a href="mailto:{{ $contactEmail }}" class="text-purple-600 dark:text-purple-400 hover:underline">{{ $contactEmail }}</a>
                        </div>
                    </div>
                    @endif
                    @if($contactPhone)
                    <div class="flex items-center mb-4">
                        <x-heroicon-o-phone class="w-6 h-6 text-purple-600 dark:text-purple-400 mr-3"/>
                        <div>
                            <h3 class="font-medium text-gray-700 dark:text-gray-200">Call Us</h3>
                            <a href="tel:{{ $contactPhone }}" class="text-purple-600 dark:text-purple-400 hover:underline">{{ $contactPhone }}</a>
                        </div>
                    </div>
                    @endif
                    @if($whatsappNumber)
                    <div class="flex items-center">
                           <i class="fab fa-whatsapp w-6 h-6 text-green-500 mr-3 text-2xl"></i>
                        <div>
                            <h3 class="font-medium text-gray-700 dark:text-gray-200">WhatsApp</h3>
                            <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $whatsappNumber) }}?text={{ urlencode($whatsappMessage) }}" target="_blank" class="text-green-500 hover:underline">{{ $whatsappNumber }}</a>
                        </div>
                    </div>
                    @endif

                    {{-- Physical Address --}}
                    @if(setting('contact_address_street') || setting('contact_address_city'))
                    <div class="flex items-start pt-4 border-t border-gray-200 dark:border-gray-700">
                        <i class="fas fa-map-marker-alt w-6 h-6 text-purple-600 dark:text-purple-400 mr-3 mt-1"></i>
                        <div>
                            <h3 class="font-medium text-gray-700 dark:text-gray-200">Our Address</h3>
                            <p class="text-gray-600 dark:text-gray-400">
                                {{ setting('contact_address_street') }}<br>
                                @if(setting('contact_address_city')){{ setting('contact_address_city') }}@endif
                                @if(setting('contact_address_state')){{ ', ' . setting('contact_address_state') }}@endif
                                @if(setting('contact_address_zip')){{ ' ' . setting('contact_address_zip') }}@endif
                                @if(setting('contact_address_country'))<br>{{ setting('contact_address_country') }}@endif
                            </p>
                        </div>
                    </div>
                    @endif
                </div>
                {{-- You can add a map here if you have a physical address setting --}}

                {{-- Social Media Links --}}
                @if(setting('social_facebook_url') || setting('social_twitter_url') || setting('social_linkedin_url') || setting('social_instagram_url'))
                <div class="bg-white dark:bg-gray-800 p-6 rounded-xl shadow-lg">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-100 mb-4">Follow Us</h2>
                    <div class="flex space-x-6">
                        @if(setting('social_facebook_url'))<a href="{{ setting('social_facebook_url') }}" target="_blank" class="text-gray-500 hover:text-blue-600 dark:text-gray-400 dark:hover:text-blue-400 transition-colors"><i class="fab fa-facebook-f fa-2x"></i></a>@endif
                        @if(setting('social_twitter_url'))<a href="{{ setting('social_twitter_url') }}" target="_blank" class="text-gray-500 hover:text-sky-500 dark:text-gray-400 dark:hover:text-sky-400 transition-colors"><i class="fab fa-twitter fa-2x"></i></a>@endif
                        @if(setting('social_linkedin_url'))<a href="{{ setting('social_linkedin_url') }}" target="_blank" class="text-gray-500 hover:text-blue-700 dark:text-gray-400 dark:hover:text-blue-500 transition-colors"><i class="fab fa-linkedin-in fa-2x"></i></a>@endif
                        @if(setting('social_instagram_url'))<a href="{{ setting('social_instagram_url') }}" target="_blank" class="text-gray-500 hover:text-pink-600 dark:text-gray-400 dark:hover:text-pink-500 transition-colors"><i class="fab fa-instagram fa-2x"></i></a>@endif
                        {{-- Add more social icons as needed --}}
                    </div>
                </div>
                @endif
            </div>

            {{-- Ticket Submission Form Column --}}
            <div class="bg-white dark:bg-gray-800 p-6 sm:p-8 rounded-xl shadow-lg">
                <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-100 mb-6">Send us a Message / Support Ticket</h2>
                @if (session('success'))
                    <div class="mb-4 p-4 text-sm text-green-700 bg-green-100 dark:bg-green-900 dark:text-green-300 rounded-lg" role="alert">
                        {{ session('success') }}
                    </div>
                @endif
                @if (session('error'))
                    <div class="mb-4 p-4 text-sm text-red-700 bg-red-100 dark:bg-red-900 dark:text-red-300 rounded-lg" role="alert">
                        {{ session('error') }}
                    </div>
                @endif

                <form action="{{ route('frontend.contact.submit') }}" method="POST" class="space-y-6">
                    @csrf
                    <div>
                        <x-label for="name" value="{{ __('Your Name') }}" />
                        <x-input id="name" name="name" type="text" class="mt-1 block w-full" :value="old('name', Auth::check() ? Auth::user()->name : '')" required />
                        {{-- Pass validation messages for 'name' --}}
                        <x-input-error :messages="$errors->get('name')" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="email" value="{{ __('Your Email Address') }}" />
                        <x-input id="email" name="email" type="email" class="mt-1 block w-full" :value="old('email', Auth::check() ? Auth::user()->email : '')" required />
                        {{-- Pass validation messages for 'email' --}}
                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="subject" value="{{ __('Subject') }}" />
                        <x-input id="subject" name="subject" type="text" class="mt-1 block w-full" :value="old('subject')" required />
                        {{-- Pass validation messages for 'subject' --}}
                        <x-input-error :messages="$errors->get('subject')" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="message" value="{{ __('Message') }}" />
                        <textarea id="message" name="message" rows="5" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm" required>{{ old('message') }}</textarea>
                        {{-- Pass validation messages for 'message' --}}
                        <x-input-error :messages="$errors->get('message')" class="mt-2" />
                    </div>
                    <div>
                        <x-label for="priority" value="{{ __('Priority') }}" />
                        <select id="priority" name="priority" class="mt-1 block w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                            <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>Low</option>
                            <option value="medium" {{ old('priority', 'medium') == 'medium' ? 'selected' : '' }}>Medium</option>
                            <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>High</option>
                        </select>
                        {{-- Pass validation messages for 'priority' --}}
                        <x-input-error :messages="$errors->get('priority')" class="mt-2" />
                    </div>
                    <div>
                        <x-button class="w-full justify-center">
                            {{ __('Send Message') }}
                        </x-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection