<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Dashboard') }} {{-- Changed from "Dashboard Overview" to just "Dashboard" for consistency with other pages --}}
            @php
                $headerCreditsSystemEnabled = function_exists('setting') && setting('credits_system_enabled', '0') == '1';
                $headerCreditNamePlural = $headerCreditsSystemEnabled ? setting('credits_display_name_plural', __('Credits')) : __('Credits');
            @endphp
            {{-- Display user's current credit balance if credits are enabled --}}
            @if($headerCreditsSystemEnabled && Auth::user())
                <span class="ml-4 text-sm text-gray-600 dark:text-gray-400">
                    ({{ Str::ucfirst($headerCreditNamePlural) . ':' }} {{ number_format(Auth::user()->credit_balance ?? 0) }})
                </span>
            @endif
            {{-- Add Teams link --}}
            @if (Laravel\Jetstream\Jetstream::hasTeamFeatures() && Auth::user()->currentTeam)
                <span class="ml-2 text-sm text-gray-500 dark:text-gray-400">|</span>
                <a href="{{ route('teams.show', Auth::user()->currentTeam->id) }}" class="ml-2 text-sm text-blue-600 dark:text-blue-400 hover:underline">{{ __('Team Settings') }}</a>
            @endif
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Welcome Banner -->
            <div class="bg-blue-600 dark:bg-blue-700 shadow-xl sm:rounded-lg p-6 md:p-8 text-white mb-8">
                <h3 class="text-2xl md:text-3xl font-semibold">Welcome, {{ Auth::user()->name }}!</h3>
                <p class="mt-2 opacity-90">Here's a quick overview of your account. We're here to help if you need anything!</p>
            </div>

            <!-- Accessible Features Section -->
            @if(isset($userMenuItems) && !empty($userMenuItems))
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg p-6 lg:p-8 mb-8">
                <h3 class="text-xl font-medium text-gray-900 dark:text-gray-100 mb-6">{{ __('Your Accessible Features & Services') }}</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($userMenuItems as $moduleDisplayName => $items)
                        @foreach($items as $item)
                            <a href="{{ route($item['route_name']) }}" class="block p-4 bg-slate-50 dark:bg-slate-700/50 rounded-lg shadow hover:shadow-md transition-shadow duration-200">
                                <div class="flex items-center">
                                    @if(isset($item['icon_svg_path']))
                                        <div class="flex-shrink-0 bg-blue-500 dark:bg-blue-600 text-white rounded-md p-2 mr-3">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $item['icon_svg_path'] }}"></path></svg>
                                        </div>
                                    @else
                                        <div class="flex-shrink-0 bg-gray-500 dark:bg-gray-600 text-white rounded-md p-2 mr-3">
                                            <x-heroicon-o-puzzle-piece class="w-5 h-5" /> {{-- Default icon --}}
                                        </div>
                                    @endif
                                    <div>
                                        <p class="text-md font-semibold text-gray-800 dark:text-gray-100">{{ $item['title'] }}</p>
                                        <p class="text-xs text-gray-500 dark:text-gray-400">{{ $moduleDisplayName }}</p>
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    @endforeach
                </div>
            </div>
            @endif


            @php
                $walletEnabled = function_exists('setting') && setting('wallet_system_enabled', '0') == '1';
                $creditsEnabled = function_exists('setting') && setting('credits_system_enabled', '0') == '1';
                $creditNameSingular = $creditsEnabled ? setting('credits_display_name_singular', __('Credit')) : __('Credit');
                $creditNamePlural = $creditsEnabled ? setting('credits_display_name_plural', __('Credits')) : __('Credits');
                $allowCreditPurchase = $creditsEnabled && function_exists('setting') && setting('allow_credit_purchase', '0') == '1';
            @endphp

            @if ($walletEnabled || $creditsEnabled)
            <div class="grid grid-cols-1 {{ ($walletEnabled && $creditsEnabled) ? 'md:grid-cols-2' : '' }} gap-6 mb-8">
                <!-- Wallet Balance -->
                @if($walletEnabled)
                <div class="p-6 bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                    <h4 class="text-lg font-semibold text-gray-700 dark:text-gray-200 mb-2">Wallet Balance</h4>
                    <p class="text-3xl font-bold text-green-600 dark:text-green-400">${{ number_format(Auth::user()->wallet_balance ?? 0, 2) }}</p>
                    <div class="mt-4 space-x-0 sm:space-x-3 space-y-2 sm:space-y-0 flex flex-col sm:flex-row items-start">
                        @if(function_exists('setting') && setting('allow_wallet_deposits', '0') == '1')
                        <a href="{{ route('user.wallet.deposit.form') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">Deposit Funds</a>
                        @endif
                        @if(Route::has('user.wallet.history'))
                        <a href="{{ route('user.wallet.history') }}" class="inline-flex items-center px-4 py-2 bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest hover:bg-gray-300 active:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 dark:bg-gray-600 dark:text-gray-200 dark:hover:bg-gray-500 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">View History</a>
                        @endif
                    </div>
                </div>
                @endif

                <!-- Credit Balance -->
                @if($creditsEnabled)
                <div class="p-6 bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                    <h4 class="text-lg font-semibold text-gray-700 dark:text-gray-200 mb-2">{{ Str::ucfirst($creditNameSingular) }} Balance</h4>
                    <p class="text-3xl font-bold text-purple-600 dark:text-purple-400">{{ number_format(Auth::user()->credit_balance ?? 0) }} <span class="text-xl">{{ strtolower($creditNamePlural) }}</span></p>
                    <div class="mt-4 space-x-0 sm:space-x-3 space-y-2 sm:space-y-0 flex flex-col sm:flex-row items-start">
                        @if($allowCreditPurchase && Route::has('user.credits.purchase.form')) {{-- Assuming 'user.credits.purchase.form' is your route name --}}
                        <a href="{{ route('user.credits.purchase.form') }}" class="inline-flex items-center px-4 py-2 bg-purple-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-purple-700 active:bg-purple-800 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">Purchase {{ Str::ucfirst($creditNamePlural) }}</a>
                        @endif
                        @if(Route::has('user.credits.history')) {{-- No need for $creditsEnabled check here as it's already checked for the widget --}}
                        <a href="{{ route('user.credits.history') }}" class="inline-flex items-center px-4 py-2 bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest hover:bg-gray-300 active:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 dark:bg-gray-600 dark:text-gray-200 dark:hover:bg-gray-500 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">View History</a>
                        @endif
                    </div>
                </div>
                @endif
            </div>
            @endif

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                <!-- Support Tickets Widget -->
                <a href="{{ route('user.tickets.index') }}" class="block p-6 bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 bg-blue-500 dark:bg-blue-600 rounded-md p-3">
                            <svg class="h-7 w-7 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 002 2h1c1.105 0 2-.895 2-2v-1a2 2 0 00-2-2H5zM5 14a2 2 0 00-2 2v3a2 2 0 002 2h1c1.105 0 2-.895 2-2v-1a2 2 0 00-2-2H5z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-lg font-semibold text-gray-900 dark:text-gray-100">Support Tickets</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">View & manage your requests</p>
                        </div>
                    </div>
                    {{-- You can add a count of open tickets here if available --}}
                    {{-- <p class="text-xs text-blue-500 dark:text-blue-400 mt-2">3 Open Tickets</p> --}}
                </a>

                <!-- My Profile Widget -->
                <a href="{{ route('profile.show') }}" class="block p-6 bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg hover:shadow-2xl transform hover:-translate-y-1 transition-all duration-300">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 bg-blue-500 dark:bg-blue-600 rounded-md p-3">
                            <svg class="h-7 w-7 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-lg font-semibold text-gray-900 dark:text-gray-100">My Profile</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Update your account details</p>
                        </div>
                    </div>
                </a>

                <!-- Placeholder for another widget -->
                <div class="p-6 bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 bg-blue-500 dark:bg-blue-600 rounded-md p-3">
                            <svg class="h-7 w-7 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <p class="text-lg font-semibold text-gray-900 dark:text-gray-100">Quick Actions</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">More features coming soon...</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Messages/Chat Overview (Placeholder) -->
            <div class="bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg p-6 md:p-8">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-4">Recent Messages</h3>
                <div class="border dark:border-gray-700 rounded-md p-6 min-h-[200px] flex flex-col items-center justify-center text-center">
                    <svg class="w-12 h-12 text-gray-300 dark:text-gray-600 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path></svg>
                    <p class="text-gray-500 dark:text-gray-400">Your recent conversations will appear here.</p>
                    <p class="text-sm text-gray-400 dark:text-gray-500 mt-1">Use the floating chat icon to start a new conversation with support.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Floating Chat Widget -->
    <div id="user-chat-widget-container" class="fixed bottom-6 right-6 z-[1000]">
        <div id="user-chat-window" class="hidden absolute bottom-16 right-0 w-80 sm:w-96 bg-white dark:bg-gray-800 rounded-lg shadow-2xl flex flex-col border border-gray-300 dark:border-gray-700" style="max-height: 70vh;">
            <div class="bg-blue-600 text-white p-3 rounded-t-lg flex justify-between items-center cursor-move" id="user-chat-header">
                <h5 class="font-semibold text-sm">Chat with Support</h5>
                <button id="user-chat-close" class="text-blue-200 hover:text-white text-xl leading-none">&times;</button>
            </div>
            <div class="flex-grow p-4 overflow-y-auto space-y-3" id="user-chat-messages">
                <!-- Example Messages -->
                <div class="flex">
                    <div class="bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-gray-200 p-2 rounded-lg max-w-[80%]">
                        <p class="text-xs">Hi there! How can I help you today?</p>
                        <p class="text-right text-xs text-gray-500 dark:text-gray-400 mt-1">Support - 2 min ago</p>
                    </div>
                </div>
                <div class="flex justify-end">
                     <div class="bg-blue-500 text-white p-2 rounded-lg max-w-[80%]">
                        <p class="text-xs">I have a question about my recent order.</p>
                        <p class="text-right text-xs text-blue-200 mt-1">You - 1 min ago</p>
                    </div>
                </div>
                {{-- End Example Messages --}}
                <p class="text-center text-xs text-gray-400 dark:text-gray-500 py-2" id="chat-placeholder-message">Type your message below to start chatting.</p>
            </div>
            <div class="p-3 border-t border-gray-200 dark:border-gray-700">
                <div class="flex items-center">
                    <input type="text" id="user-chat-input" placeholder="Type your message..." class="flex-grow p-2 border border-gray-300 dark:border-gray-600 rounded-l-md dark:bg-gray-700 dark:text-gray-200 focus:ring-blue-500 focus:border-blue-500 text-sm">
                    <button id="user-chat-send" class="bg-blue-600 hover:bg-blue-700 text-white p-2 rounded-r-md text-sm">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path></svg>
                    </button>
                </div>
            </div>
        </div>
        <button id="user-chat-toggle" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-full shadow-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition-transform transform hover:scale-110">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path></svg>
        </button>
    </div>

    @push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const chatToggle = document.getElementById('user-chat-toggle');
            const chatWindow = document.getElementById('user-chat-window');
            const chatClose = document.getElementById('user-chat-close');
            const chatMessagesContainer = document.getElementById('user-chat-messages');
            const chatInput = document.getElementById('user-chat-input');
            const chatSendButton = document.getElementById('user-chat-send');
            const chatPlaceholderMessage = document.getElementById('chat-placeholder-message');

            if (chatToggle && chatWindow && chatClose) {
                chatToggle.addEventListener('click', () => {
                    chatWindow.classList.toggle('hidden');
                    if (!chatWindow.classList.contains('hidden')) {
                        chatInput.focus();
                        // Scroll to bottom if opening
                        chatMessagesContainer.scrollTop = chatMessagesContainer.scrollHeight;
                    }
                });
                chatClose.addEventListener('click', () => {
                    chatWindow.classList.add('hidden');
                });
            }

            // Basic function to add a message to the chat window
            function addChatMessage(message, sender, isUser = false) {
                if(chatPlaceholderMessage) chatPlaceholderMessage.classList.add('hidden');

                const messageDiv = document.createElement('div');
                messageDiv.classList.add('flex', 'mb-2');
                if (isUser) {
                    messageDiv.classList.add('justify-end');
                }

                const bubbleDiv = document.createElement('div');
                bubbleDiv.classList.add('p-2', 'rounded-lg', 'max-w-[80%]', 'text-xs');
                if (isUser) {
                    bubbleDiv.classList.add('bg-blue-500', 'text-white');
                } else {
                    bubbleDiv.classList.add('bg-gray-200', 'dark:bg-gray-700', 'text-gray-800', 'dark:text-gray-200');
                }

                const messageP = document.createElement('p');
                messageP.textContent = message;
                bubbleDiv.appendChild(messageP);

                const timeP = document.createElement('p');
                timeP.classList.add('text-xs', 'mt-1');
                if (isUser) {
                    timeP.classList.add('text-right', 'text-blue-200');
                } else {
                    timeP.classList.add('text-right', 'text-gray-500', 'dark:text-gray-400');
                }
                timeP.textContent = `${sender} - now`; // Simple timestamp
                bubbleDiv.appendChild(timeP);

                messageDiv.appendChild(bubbleDiv);
                chatMessagesContainer.appendChild(messageDiv);
                chatMessagesContainer.scrollTop = chatMessagesContainer.scrollHeight; // Scroll to bottom
            }

            // Handle sending a message (UI only for now)
            if (chatSendButton && chatInput) {
                const sendMessage = () => {
                    const messageText = chatInput.value.trim();
                    if (messageText) {
                        addChatMessage(messageText, 'You', true);
                        chatInput.value = '';
                        // Here you would typically send the message to the server via AJAX/WebSockets
                        // And then receive a response from support
                        setTimeout(() => {
                            addChatMessage("Thanks for your message! A support agent will be with you shortly.", "Support");
                        }, 1500);
                    }
                };
                chatSendButton.addEventListener('click', sendMessage);
                chatInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        sendMessage();
                    }
                });
            }
        });
    </script>
    @endpush
</x-app-layout>
