@props(['active' => false, 'href'])

@php
$classes = ($active ?? false)
            ? 'inline-flex items-center w-full text-sm font-semibold text-blue-600 dark:text-blue-400 transition-colors duration-150 hover:text-gray-800 dark:hover:text-gray-200 border-r-4 border-blue-500 dark:border-blue-500 bg-blue-50 dark:bg-gray-700/50'
            : 'inline-flex items-center w-full text-sm font-medium text-gray-600 dark:text-gray-400 transition-colors duration-150 hover:text-gray-800 dark:hover:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700';
@endphp

<a href="{{ $href }}" {{ $attributes->merge(['class' => $classes]) }}>
    @if ($active)
    <span class="absolute inset-y-0 left-0 w-1 bg-blue-500 dark:bg-blue-500 rounded-tr-lg rounded-br-lg" aria-hidden="true"></span>
    @endif
    {{ $slot }}
</a>