<x-guest-layout>
    <x-authentication-card>
        <x-slot name="logo">
            <x-authentication-card-logo />
        </x-slot>

        <x-validation-errors class="mb-4" />

        <form method="POST" action="{{ route('register') }}">
            @csrf

            <div>
                <x-label for="name" value="{{ __('Name') }}" />
                <x-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name')" required autofocus autocomplete="name" />
            </div>

            <div class="mt-4">
                <x-label for="email" value="{{ __('Email') }}" />
                <x-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autocomplete="username" />
            </div>

            <div class="mt-4">
                <x-label for="password" value="{{ __('Password') }}" />
                <x-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="new-password" />
            </div>

            <div class="mt-4">
                <x-label for="password_confirmation" value="{{ __('Confirm Password') }}" />
                <x-input id="password_confirmation" class="block mt-1 w-full" type="password" name="password_confirmation" required autocomplete="new-password" />
            </div>

            {{-- Role Selection Dropdown --}}
            @if(function_exists('setting') && setting('enable_role_selection_on_registration', '0') == '1')
                @php
                    // Fetch roles marked for registration
                    // Ensure SpatieRole is imported in CreateNewUser.php or use full namespace here if needed for clarity,
                    // but direct model usage in Blade is generally okay for simple queries.
                    $registrationRoles = \Spatie\Permission\Models\Role::where('show_on_registration', true)
                                            ->where('guard_name', 'web') // Important for multi-guard apps
                                            ->orderBy('name')
                                            ->get();
                @endphp

                @if($registrationRoles->isNotEmpty())
                    <div class="mt-4">
                        <x-label for="selected_role" value="{{ __('I am a...') }}" />
                        <select id="selected_role" name="selected_role" class="block mt-1 w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                            <option value="">-- {{ __('Select your role (Optional)') }} --</option>
                            @foreach($registrationRoles as $regRole)
                                <option value="{{ $regRole->name }}" {{ old('selected_role') == $regRole->name ? 'selected' : '' }}>
                                    {{ Str::title(str_replace('_', ' ', $regRole->name)) }} {{-- Display role name nicely --}}
                                </option>
                            @endforeach
                        </select>
                        @error('selected_role') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                @endif
            @endif

            @if (Laravel\Jetstream\Jetstream::hasTermsAndPrivacyPolicyFeature())
                <div class="mt-4">
                    <x-label for="terms">
                        <div class="flex items-center">
                            <x-checkbox name="terms" id="terms" required />

                            <div class="ms-2">
                                {!! __('I agree to the :terms_of_service and :privacy_policy', [
                                        'terms_of_service' => '<a target="_blank" href="'.route('terms.show').'" class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">'.__('Terms of Service').'</a>',
                                        'privacy_policy' => '<a target="_blank" href="'.route('policy.show').'" class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">'.__('Privacy Policy').'</a>',
                                ]) !!}
                            </div>
                        </div>
                    </x-label>
                </div>
            @endif

            <div class="flex items-center justify-end mt-4">
                <a class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" href="{{ route('login') }}">
                    {{ __('Already registered?') }}
                </a>

                <x-button class="ms-4">
                    {{ __('Register') }}
                </x-button>
            </div>
        </form>

        {{-- Social Logins for Registration --}}
        @if (function_exists('setting'))
            @php
                $googleEnabled = setting('google_login_enabled', '0') === '1' && config('services.google.client_id') && config('services.google.client_secret');
                $facebookEnabled = setting('facebook_login_enabled', '0') === '1' && config('services.facebook.client_id') && config('services.facebook.client_secret');
            @endphp

            @if ($googleEnabled || $facebookEnabled)
                <div class="flex items-center justify-center mt-6">
                    <span class="text-sm text-gray-500 dark:text-gray-400">Or register with</span>
                </div>
                <div class="flex flex-col sm:flex-row items-center justify-center mt-4 space-y-2 sm:space-y-0 sm:space-x-2">
                    @if ($googleEnabled)
                        <a href="{{ route('social.redirect', 'google') }}"
                           class="inline-flex items-center justify-center px-4 py-2 bg-red-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-red-500 active:bg-red-700 focus:outline-none focus:border-red-700 focus:ring focus:ring-red-200 disabled:opacity-25 transition w-full sm:w-auto">
                            <svg class="w-4 h-4 mr-2 -ml-1" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M20.283 10.356h-8.327v3.451h4.792c-.446 2.193-2.313 3.453-4.792 3.453a5.27 5.27 0 0 1-5.279-5.28 5.27 5.27 0 0 1 5.279-5.279c1.259 0 2.397.447 3.29 1.178l2.6-2.599c-1.584-1.381-3.615-2.233-5.89-2.233a8.908 8.908 0 0 0-8.934 8.934 8.907 8.907 0 0 0 8.934 8.934c4.467 0 8.529-3.249 8.529-8.934 0-.528-.081-1.097-.202-1.625z"></path></svg>
                            Register with Google
                        </a>
                    @endif
                    @if ($facebookEnabled)
                        <a href="{{ route('social.redirect', 'facebook') }}"
                           class="inline-flex items-center justify-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-500 active:bg-blue-700 focus:outline-none focus:border-blue-700 focus:ring focus:ring-blue-200 disabled:opacity-25 transition w-full sm:w-auto">
                            <svg class="w-4 h-4 mr-2 -ml-1" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"></path></svg>
                            Register with Facebook
                        </a>
                    @endif
                </div>
            @endif
        @endif
    </x-authentication-card>
</x-guest-layout>
