@extends('layouts.admin')

@section('title', 'Withdrawal Request #' . $withdrawalRequest->id)

@section('content_header')
    <div class="flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Withdrawal Request Details</h1>
        <a href="{{ route('admin.wallet-withdrawal-requests.index') }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
            &larr; Back to Withdrawal Requests
        </a>
    </div>
@stop

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    @include('admin.partials.alerts')

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        {{-- Request Details --}}
        <div class="md:col-span-2 bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Request #{{ $withdrawalRequest->id }}</h3>
            </div>
            <div class="p-6">
                <dl class="grid grid-cols-1 sm:grid-cols-2 gap-x-4 gap-y-6">
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">User</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                            <a href="{{ route('admin.users.edit', $withdrawalRequest->user->id) }}" class="text-indigo-600 hover:underline dark:text-indigo-400">
                                {{ $withdrawalRequest->user->name }} ({{ $withdrawalRequest->user->email }})
                            </a>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Amount</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $withdrawalRequest->currency }} {{ number_format($withdrawalRequest->amount, 2) }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Withdrawal Method</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ Str::title(str_replace('_', ' ', $withdrawalRequest->withdrawal_method)) }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Requested At</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $withdrawalRequest->created_at->format('M d, Y H:i:s') }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Current Status</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                @if($withdrawalRequest->status === 'pending') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                @elseif($withdrawalRequest->status === 'approved') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100
                                @elseif($withdrawalRequest->status === 'processing') bg-indigo-100 text-indigo-800 dark:bg-indigo-700 dark:text-indigo-100
                                @elseif($withdrawalRequest->status === 'completed') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                @elseif($withdrawalRequest->status === 'rejected') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                {{ $statuses[$withdrawalRequest->status] ?? Str::title($withdrawalRequest->status) }}
                            </span>
                        </dd>
                    </div>
                    @if($withdrawalRequest->processed_at)
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Processed At</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $withdrawalRequest->processed_at->format('M d, Y H:i:s') }}</dd>
                    </div>
                    @endif
                    <div class="sm:col-span-2">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Payment Details</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                            <pre class="whitespace-pre-wrap bg-gray-50 dark:bg-gray-700 p-3 rounded-md text-xs">{{ json_encode($withdrawalRequest->payment_details, JSON_PRETTY_PRINT) }}</pre>
                        </dd>
                    </div>
                    @if($withdrawalRequest->admin_notes)
                    <div class="sm:col-span-2">
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Admin Notes</dt>
                        <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 prose dark:prose-invert max-w-none">{{ $withdrawalRequest->admin_notes }}</dd>
                    </div>
                    @endif
                </dl>
            </div>
        </div>

        {{-- Actions --}}
        <div class="md:col-span-1 bg-white dark:bg-gray-800 shadow-md rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Manage Request</h3>
            </div>
            <form action="{{ route('admin.wallet-withdrawal-requests.updateStatus', $withdrawalRequest->id) }}" method="POST" class="p-6 space-y-4">
                @csrf
                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Update Status</label>
                    <select name="status" id="status" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300">
                        @foreach($statuses as $key => $value)
                            <option value="{{ $key }}" {{ $withdrawalRequest->status == $key ? 'selected' : '' }}>{{ $value }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label for="admin_notes" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Admin Notes (Optional)</label>
                    <textarea name="admin_notes" id="admin_notes" rows="4" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300">{{ old('admin_notes', $withdrawalRequest->admin_notes) }}</textarea>
                </div>
                <div>
                    <button type="submit" class="w-full inline-flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        Update Request
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

