@extends('layouts.admin')

@section('title', 'Create New User')
@section('header_title', 'Create New User')

@section('content')
<div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
    <div class="p-6 lg:p-8">
        @include('admin.partials.alerts')

        <form action="{{ route('admin.users.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Name -->
                <div class="mb-4">
                    <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Name</label>
                    <input type="text" name="name" id="name" value="{{ old('name') }}" required
                           class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:bg-gray-700 dark:text-gray-200">
                    @error('name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                </div>

                <!-- Email -->
                <div class="mb-4">
                    <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Email</label>
                    <input type="email" name="email" id="email" value="{{ old('email') }}" required
                           class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:bg-gray-700 dark:text-gray-200">
                    @error('email') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                </div>

                <!-- Password -->
                <div class="mb-4">
                    <label for="password" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Password</label>
                    <input type="password" name="password" id="password" required
                           class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:bg-gray-700 dark:text-gray-200">
                    @error('password') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                </div>

                <!-- Confirm Password -->
                <div class="mb-4">
                    <label for="password_confirmation" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Confirm Password</label>
                    <input type="password" name="password_confirmation" id="password_confirmation" required
                           class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:bg-gray-700 dark:text-gray-200">
                </div>

                <!-- Simple Role (super_admin, admin, user) -->
                @if(Auth::user()->isSuperAdmin() && isset($roles))
                <div class="mb-4 md:col-span-2">
                    <label for="role" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Assign Basic Role</label>
                    <select name="role" id="role" required
                            class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:bg-gray-700 dark:text-gray-200">
                        @foreach($roles as $roleValue => $roleName)
                            <option value="{{ $roleValue }}" {{ old('role', 'user') == $roleValue ? 'selected' : '' }}>
                                {{ $roleName }}
                            </option>
                        @endforeach
                    </select>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Only Super Admins can set this. Determines high-level access.</p>
                    @error('role') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                </div>
                @else
                    {{-- If not super_admin, new users default to 'user' role --}}
                    <input type="hidden" name="role" value="user">
                @endif

                <!-- Spatie Roles Assignment -->
                @if(Auth::user()->isSuperAdmin() && isset($assignableRoles))
                <div class="mb-6 md:col-span-2">
                    <label for="spatie_roles" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Assign System Roles (Detailed Permissions)</label>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mb-1">Select one or more roles. These roles grant specific feature permissions.</p>
                    <select name="spatie_roles[]" id="spatie_roles" multiple
                            class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm h-32">
                        @foreach($assignableRoles as $spatieRole)
                            <option value="{{ $spatieRole->name }}"
                                {{ (is_array(old('spatie_roles')) && in_array($spatieRole->name, old('spatie_roles'))) ? 'selected' : '' }}>
                                {{ $spatieRole->name }}
                            </option>
                        @endforeach
                    </select>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Hold Ctrl (or Cmd on Mac) to select multiple roles. Only Super Admins can change these.</p>
                    @error('spatie_roles') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                    @error('spatie_roles.*') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                </div>
                @endif

            </div>

            <div class="mt-8 flex justify-end">
                <a href="{{ route('admin.users.index') }}" class="bg-white dark:bg-gray-700 py-2 px-4 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 mr-3">
                    Cancel
                </a>
                <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800">
                    Create User
                </button>
            </div>
        </form>
    </div>
</div>
@endsection