@extends('layouts.admin')

@section('title', 'Ticket Details: ' . $ticket->subject)
@section('header_title', 'Ticket Details')

@section('content')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        {{-- Main Ticket Content --}}
        <div class="md:col-span-2 space-y-6">
            <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-100">{{ $ticket->subject }}</h2>
                        <p class="text-sm text-gray-500 dark:text-gray-400">
                            Submitted by: {{ $ticket->user->name }} ({{ $ticket->user->email }}) on {{ $ticket->created_at->format('M d, Y H:i A') }}
                        </p>
                    </div>
                    <span class="px-3 py-1 text-xs font-semibold rounded-full
                        @if($ticket->status == 'open') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100 @endif
                        @if($ticket->status == 'pending_user_reply') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100 @endif
                        @if($ticket->status == 'pending_admin_reply') bg-orange-100 text-orange-800 dark:bg-orange-700 dark:text-orange-100 @endif
                        @if($ticket->status == 'closed') bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-100 @endif
                    ">
                        {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                    </span>
                </div>
                <div class="prose dark:prose-invert max-w-none">
                    <p class="font-semibold">Initial Message:</p>
                    {!! nl2br(e($ticket->message)) !!}
                </div>
            </div>

            <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">Replies</h3>
                @if($ticket->replies->isEmpty())
                    <p class="text-gray-500 dark:text-gray-400">No replies yet.</p>
                @else
                    @foreach($ticket->replies as $reply)
                        <div class="mb-4 p-4 border dark:border-gray-700 rounded-md {{ $reply->user->is_admin ? 'bg-green-50 dark:bg-green-900/30' : 'bg-gray-50 dark:bg-gray-700/30' }}">
                            <p class="font-semibold text-gray-800 dark:text-gray-100">{{ $reply->user->name }} <span class="text-xs text-gray-500 dark:text-gray-400">({{ $reply->created_at->diffForHumans() }}) {{ $reply->user->is_admin ? '(Admin)' : '' }}</span></p>
                            <div class="prose dark:prose-invert max-w-none mt-1 text-gray-700 dark:text-gray-300">
                                {!! nl2br(e($reply->message)) !!}
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>

            @if($ticket->status !== 'closed')
            <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">Submit a Reply (Admin)</h3>
                <form action="{{ route('admin.tickets.reply', $ticket) }}" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label for="message" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Your Message</label>
                        <textarea name="message" id="message" rows="5" required
                                  class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 dark:bg-gray-700 dark:text-gray-200">{{ old('message') }}</textarea>
                        @error('message') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>
                    <div class="flex items-center justify-end mt-4">
                        <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-500 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring focus:ring-blue-300 disabled:opacity-25 transition">
                            Submit Reply
                        </button>
                    </div>
                </form>
            </div>
            @endif
        </div>

        {{-- Sidebar for Actions --}}
        <div class="md:col-span-1 space-y-6">
            <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">Ticket Actions</h3>

                {{-- Change Status --}}
                <form action="{{ route('admin.tickets.updateStatus', $ticket) }}" method="POST" class="mb-4">
                    @csrf
                    <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Change Status</label>
                    <select name="status" id="status" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 dark:bg-gray-700 dark:text-gray-200">
                        <option value="open" {{ $ticket->status == 'open' ? 'selected' : '' }}>Open</option>
                        <option value="pending_user_reply" {{ $ticket->status == 'pending_user_reply' ? 'selected' : '' }}>Pending User Reply</option>
                        <option value="pending_admin_reply" {{ $ticket->status == 'pending_admin_reply' ? 'selected' : '' }}>Pending Admin Reply</option>
                        <option value="closed" {{ $ticket->status == 'closed' ? 'selected' : '' }}>Closed</option>
                    </select>
                    <button type="submit" class="mt-2 w-full inline-flex justify-center items-center px-4 py-2 bg-yellow-500 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-yellow-600 focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition">
                        Update Status
                    </button>
                </form>

                {{-- Assign Ticket --}}
                <form action="{{ route('admin.tickets.assign', $ticket) }}" method="POST">
                    @csrf
                    <label for="assigned_to" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Assign to Admin</label>
                    <select name="assigned_to" id="assigned_to" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 dark:bg-gray-700 dark:text-gray-200">
                        <option value="">Unassigned</option>
                        @foreach($admins as $admin)
                            <option value="{{ $admin->id }}" {{ $ticket->assigned_to == $admin->id ? 'selected' : '' }}>{{ $admin->name }}</option>
                        @endforeach
                    </select>
                    <button type="submit" class="mt-2 w-full inline-flex justify-center items-center px-4 py-2 bg-green-500 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-600 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition">
                        Assign Ticket
                    </button>
                </form>
            </div>

            <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-2">Ticket Information</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400"><strong>Priority:</strong> {{ ucfirst($ticket->priority) }}</p>
                <p class="text-sm text-gray-600 dark:text-gray-400"><strong>Created:</strong> {{ $ticket->created_at->format('M d, Y H:i A') }}</p>
                <p class="text-sm text-gray-600 dark:text-gray-400"><strong>Last Updated:</strong> {{ $ticket->updated_at->diffForHumans() }}</p>
                <p class="text-sm text-gray-600 dark:text-gray-400"><strong>Last Reply:</strong> {{ $ticket->last_reply_at ? $ticket->last_reply_at->diffForHumans() : 'N/A' }}</p>
                @if($ticket->assignedAdmin)
                <p class="text-sm text-gray-600 dark:text-gray-400"><strong>Assigned To:</strong> {{ $ticket->assignedAdmin->name }}</p>
                @else
                <p class="text-sm text-gray-600 dark:text-gray-400"><strong>Assigned To:</strong> Unassigned</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection