@include('admin.partials.alerts') {{-- For displaying validation errors --}}

@php
    // Prepare Alpine.js states for features
    $featureStates = [];
    foreach($moduleFeatures ?? [] as $moduleName => $features) {
        foreach($features as $feature) {
            $featureKey = $feature['key'] ?? Str::slug($moduleName.' '.$feature['name']);
            $featureKeySlug = Str::slug($featureKey, '_');
            $isCheckedInitial = false;
            if (old('selected_features')) {
                $isCheckedInitial = in_array($featureKey, old('selected_features', []));
            } elseif (is_array($plan->features)) {
                foreach($plan->features as $planFeature) {
                    if (isset($planFeature['key']) && $planFeature['key'] === $featureKey) { $isCheckedInitial = true; break; }
                }
            }
            $featureStates[] = "selectedFeature_". $featureKeySlug .": " . ($isCheckedInitial ? 'true' : 'false');
        }
    }
@endphp

<form action="{{ $action }}" method="POST" x-data="{ {{ implode(',', $featureStates) }} }">
    @csrf
    @if($method === 'PUT')
        @method('PUT')
    @endif
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Name -->
        <div>
            <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Plan Name</label>
            <input type="text" name="name" id="name" value="{{ old('name', $plan->name) }}" required
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
            @error('name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Price -->
        <div>
            <label for="price" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Price</label>
            <input type="number" name="price" id="price" value="{{ old('price', $plan->price) }}" step="0.01" min="0" required
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
            @error('price') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Currency -->
        <div>
            <label for="currency" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Currency</label>
            <select name="currency" id="currency" required
                    class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                @php $selectedCurrency = old('currency', $plan->currency ?? 'USD'); @endphp
                @foreach($currencies as $code => $name)
                    <option value="{{ $code }}" {{ $selectedCurrency == $code ? 'selected' : '' }}>
                        {{ $name }}
                    </option>
                @endforeach
            </select>
            @error('currency') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Interval -->
        <div>
            <label for="interval" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Billing Interval</label>
            <select name="interval" id="interval" required
                    class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                <option value="day" {{ old('interval', $plan->interval) == 'day' ? 'selected' : '' }}>Day</option>
                <option value="week" {{ old('interval', $plan->interval) == 'week' ? 'selected' : '' }}>Week</option>
                <option value="month" {{ old('interval', $plan->interval) == 'month' ? 'selected' : '' }}>Month</option>
                <option value="year" {{ old('interval', $plan->interval) == 'year' ? 'selected' : '' }}>Year</option>
            </select>
            @error('interval') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Interval Count -->
        <div>
            <label for="interval_count" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Interval Count (e.g., 1 for every month, 3 for every 3 months)</label>
            <input type="number" name="interval_count" id="interval_count" value="{{ old('interval_count', $plan->interval_count ?? 1) }}" min="1" required
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
            @error('interval_count') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Trial Period Days -->
        <div>
            <label for="trial_period_days" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Trial Period (Days, 0 for none)</label>
            <input type="number" name="trial_period_days" id="trial_period_days" value="{{ old('trial_period_days', $plan->trial_period_days ?? 0) }}" min="0"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
            @error('trial_period_days') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Credits Awarded on Purchase -->
        <div>
            <label for="credits_awarded_on_purchase" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Credits Awarded on Purchase</label>
            <input type="number" name="credits_awarded_on_purchase" id="credits_awarded_on_purchase" value="{{ old('credits_awarded_on_purchase', $plan->credits_awarded_on_purchase ?? 0) }}" min="0"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
            @error('credits_awarded_on_purchase') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Credits Awarded on Renewal -->
        <div>
            <label for="credits_awarded_on_renewal" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Credits Awarded on Renewal</label>
            <input type="number" name="credits_awarded_on_renewal" id="credits_awarded_on_renewal" value="{{ old('credits_awarded_on_renewal', $plan->credits_awarded_on_renewal ?? 0) }}" min="0"
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
            @error('credits_awarded_on_renewal') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Target Role -->
        <div>
            <label for="target_role" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Target User Role</label>
            <select name="target_role" id="target_role"
                    class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                @foreach($targetRoles as $roleKey => $roleName)
                    <option value="{{ $roleKey }}" {{ old('target_role', $plan->target_role) == $roleKey ? 'selected' : '' }}>
                        {{ $roleName }}
                    </option>
                @endforeach
            </select>
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Specify if this plan is for a particular type of user.</p>
            @error('target_role') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Description -->
        <div class="md:col-span-2">
            <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description</label>
            <textarea name="description" id="description" rows="3"
                      class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">{{ old('description', $plan->description) }}</textarea>
            @error('description') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Module Features Selection -->
        <div class="md:col-span-2">
            <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-4">Module Features</h3>
            @if(empty($moduleFeatures))
                <p class="text-sm text-gray-500 dark:text-gray-400">No modules with definable features found.</p>
            @else
                <div class="space-y-6">
                    @foreach($moduleFeatures as $moduleName => $featuresInModule) {{-- Renamed $features to $featuresInModule for clarity --}}
                        <fieldset class="border border-gray-300 dark:border-gray-600 p-5 rounded-lg shadow-sm">
                            <legend class="text-md font-semibold text-gray-800 dark:text-gray-200 px-3">{{ $moduleName }}</legend>
                            <div class="mt-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                                @foreach($featuresInModule as $feature)
                                    @php
                                        $featureKey = $feature['key'] ?? Str::slug($moduleName.' '.$feature['name']);
                                        $featureKeySlug = Str::slug($featureKey, '_');
                                        $isLimitable = $feature['limitable'] ?? false;
                                        $limitLabel = $feature['limit_label'] ?? 'Set Limit';
                                        $currentLimit = '';

                                        // For initial checked state (PHP side)
                                        $isCheckedPhp = false;
                                        if (old('selected_features')) {
                                            $isCheckedPhp = in_array($featureKey, old('selected_features'));
                                            if ($isCheckedPhp && isset(old('feature_limits')[$featureKey])) {
                                                $currentLimit = old('feature_limits.'.$featureKey, '');
                                            }
                                        } elseif (is_array($plan->features)) {
                                            foreach($plan->features as $planFeature) {
                                                if (isset($planFeature['key']) && $planFeature['key'] === $featureKey) {
                                                    $isCheckedPhp = true;
                                                    $currentLimit = $planFeature['limit'] ?? '';
                                                    break;
                                                }
                                            }
                                        }
                                    @endphp
                                    <div class="flex flex-col p-4 bg-gray-50 dark:bg-gray-700/50 rounded-md border border-gray-200 dark:border-gray-600 hover:border-indigo-300 dark:hover:border-indigo-500 transition-colors duration-150">
                                        <div class="flex items-start">
                                            <div class="flex items-center h-5">
                                                <input id="feature_{{ $featureKeySlug }}" name="selected_features[]" type="checkbox" value="{{ $featureKey }}"
                                                       x-model="selectedFeature_{{ $featureKeySlug }}"
                                                       {{ $isCheckedPhp ? 'checked' : '' }}
                                                       class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-500 rounded dark:bg-gray-700 cursor-pointer">
                                            </div>
                                            <div class="ml-3 text-sm flex-1">
                                                <label for="feature_{{ $featureKeySlug }}" class="font-medium text-gray-800 dark:text-gray-100 cursor-pointer">{{ $feature['name'] }}</label>
                                                @if(isset($feature['description']))
                                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">{{ $feature['description'] }}</p>
                                                @endif
                                            </div>
                                        </div>
                                        @if($isLimitable)
                                        <div x-show="selectedFeature_{{ $featureKeySlug }}" class="mt-3 border-t border-gray-200 dark:border-gray-600 pt-3" x-transition.opacity x-transition.duration.300ms>
                                            <label for="limit_{{ $featureKeySlug }}" class="block text-xs font-medium text-gray-600 dark:text-gray-400 mb-0.5">{{ $limitLabel }} (0 or empty for unlimited)</label>
                                            <input type="number" name="feature_limits[{{ $featureKey }}]" id="limit_{{ $featureKeySlug }}" value="{{ $currentLimit }}" min="0"
                                                   class="mt-1 block w-full max-w-xs border-gray-300 dark:border-gray-500 dark:bg-gray-600 dark:text-gray-200 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm text-sm">
                                        </div>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </fieldset>
                    @endforeach
                </div>
            @endif
            @error('selected_features') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
            @error('feature_limits') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
            @foreach($moduleFeatures ?? [] as $moduleName => $featuresInModuleLoopOnError) {{-- Changed variable name to avoid conflict if $features was global --}}
                @foreach($featuresInModuleLoopOnError as $feature)
                    @php $featureKey = $feature['key'] ?? Str::slug($moduleName.' '.$feature['name']); @endphp
                    @error('feature_limits.'.$featureKey) <p class="text-red-500 text-xs mt-1">Limit for {{ $feature['name'] }}: {{ $message }}</p> @enderror
                @endforeach
            @endforeach
        </div>

        <!-- Available Payment Gateways -->
        <div class="md:col-span-2">
            <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-3 mt-6">Available Payment Gateways for this Plan</h3>
            @if(empty($availableGateways))
                <p class="text-sm text-gray-500 dark:text-gray-400">No active payment gateways found in the system. Configure them in settings.</p>
            @else
                <div class="space-y-4">
                    <fieldset class="border border-gray-300 dark:border-gray-600 p-4 rounded-md">
                        <legend class="text-md font-medium text-gray-800 dark:text-gray-200 px-2">Select Gateways</legend>
                        <div class="mt-3 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                            @foreach($availableGateways as $gatewayKey => $gatewayName)
                                @php
                                    $isGatewayChecked = false;
                                    if (old('available_gateways_input')) {
                                        $isGatewayChecked = in_array((string)$gatewayKey, (array)old('available_gateways_input', []));
                                    } elseif ($plan->available_gateways) {
                                        $isGatewayChecked = in_array((string)$gatewayKey, (array)$plan->available_gateways);
                                    }
                                @endphp
                                <div class="flex items-start">
                                    <div class="flex items-center h-5">
                                        <input id="gateway_{{ $gatewayKey }}" name="available_gateways_input[]" type="checkbox" value="{{ $gatewayKey }}"
                                               {{ $isGatewayChecked ? 'checked' : '' }}
                                               class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-500 rounded dark:bg-gray-700">
                                    </div>
                                    <div class="ml-3 text-sm">
                                        <label for="gateway_{{ $gatewayKey }}" class="font-medium text-gray-700 dark:text-gray-300">{{ $gatewayName }}</label>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </fieldset>
                </div>
            @endif
            @error('available_gateways_input') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Gateway Specific Plan IDs -->
        <div class="md:col-span-2">
            <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-3 mt-6">Gateway Specific Plan IDs</h3>
            <div class="space-y-4 p-4 border border-gray-200 dark:border-gray-700 rounded-md">

                {{-- PayPal Plan ID --}}
                <div x-show="document.getElementById('gateway_paypal_gateway')?.checked" x-transition class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-md">
                    <label for="paypal_plan_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">PayPal Plan ID</label>
                    <input type="text" name="paypal_plan_id" id="paypal_plan_id" value="{{ old('paypal_plan_id', $plan->paypal_plan_id) }}"
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    @error('paypal_plan_id') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </div>

                {{-- Stripe Product & Price IDs --}}
                <div x-show="document.getElementById('gateway_stripe_gateway')?.checked" x-transition class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-md">
                    <div>
                        <label for="stripe_product_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Stripe Product ID</label>
                        <input type="text" name="stripe_product_id" id="stripe_product_id" value="{{ old('stripe_product_id', $plan->stripe_product_id) }}"
                               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                        @error('stripe_product_id') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                    </div>
                    <div class="mt-4">
                        <label for="stripe_price_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Stripe Price ID</label>
                        <input type="text" name="stripe_price_id" id="stripe_price_id" value="{{ old('stripe_price_id', $plan->stripe_price_id) }}"
                               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                        @error('stripe_price_id') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                    </div>
                </div>

                {{-- Paystack Plan Code --}}
                <div x-show="document.getElementById('gateway_paystack_gateway')?.checked" x-transition class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-md">
                    <label for="paystack_plan_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Paystack Plan Code</label>
                    <input type="text" name="paystack_plan_code" id="paystack_plan_code" value="{{ old('paystack_plan_code', $plan->paystack_plan_code) }}"
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    @error('paystack_plan_code') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </div>

                {{-- Authorize.Net / Custom Gateway Plan ID --}}
                {{-- Assuming 'authorizenet_gateway' is the key for Authorize.Net in $availableGateways --}}
                <div x-show="document.getElementById('gateway_authorizenet_gateway')?.checked" x-transition class="p-3 bg-gray-50 dark:bg-gray-700/50 rounded-md">
                    <label for="custom_gateway_plan_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Authorize.Net / Custom Gateway Plan ID</label>
                    <input type="text" name="custom_gateway_plan_id" id="custom_gateway_plan_id" value="{{ old('custom_gateway_plan_id', $plan->custom_gateway_plan_id) }}"
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Used for Authorize.Net Automated Recurring Billing (ARB) or other custom gateways requiring a plan identifier.</p>
                    @error('custom_gateway_plan_id') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </div>

            </div>
        </div>

        <!-- Global Resource Limits -->
        <div class="md:col-span-2">
            <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-3 mt-6">Global Resource Limits</h3>
             <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                 <div>
                     <label for="limit_companies_creation_global" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Max Companies (Global)</label>
                     <input type="number" name="resource_limits[companies_creation_limit]" id="limit_companies_creation_global" value="{{ old('resource_limits.companies_creation_limit', $plan->resource_limits['companies_creation_limit'] ?? '') }}" min="0"
                            class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                     @error('resource_limits.companies_creation_limit') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                 </div>
                 {{-- Example: If you still need a global job posting limit separate from a feature --}}
                 {{-- <div>
                     <label for="limit_jobs_posting_global" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Max Job Postings (Global)</label>
                     <input type="number" name="resource_limits[jobs_posting_limit]" id="limit_jobs_posting_global" value="{{ old('resource_limits.jobs_posting_limit', $plan->resource_limits['jobs_posting_limit'] ?? '') }}" min="0"
                            class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                     @error('resource_limits.jobs_posting_limit') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                 </div> --}}
             </div>
        </div>

        <!-- Active -->
        <div class="md:col-span-2">
            <label for="active" class="flex items-center">
                <input type="checkbox" name="active" id="active" value="1" {{ old('active', $plan->active) ? 'checked' : '' }}
                       class="rounded border-gray-300 dark:border-gray-600 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:bg-gray-700 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800">
                <span class="ml-2 text-sm text-gray-600 dark:text-gray-400">Active (Plan can be selected by users)</span>
            </label>
            @error('active') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>
    </div>

    <div class="mt-6 flex justify-end">
        <a href="{{ route('admin.subscription-plans.index') }}"
           class="inline-flex items-center px-4 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-500 rounded-md font-semibold text-xs text-gray-700 dark:text-gray-300 uppercase tracking-widest shadow-sm hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 disabled:opacity-25 transition ease-in-out duration-150">
            Cancel
        </a>
        <button type="submit"
                class="ml-3 inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition ease-in-out duration-150">
            {{ $plan->exists ? 'Update Plan' : 'Create Plan' }}
        </button>
    </div>
</form>
