@extends('layouts.admin')

@section('title', 'Application Settings')
@section('header_title', 'Application Settings')

@section('content')
<div class="space-y-6" x-data="{ 
    activeMainTab: '{{ $activeMainTab }}', 
    activeSubTab: '{{ $activeMainTab === 'application' ? ($activeSubTab ?? ($applicationSettingNavItems->isNotEmpty() ? $applicationSettingNavItems->keys()->first() : '')) : '' }}' 
}">
    @if (session('success'))
        <div class="p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300" role="alert">
            {{ session('success') }}
        </div>
    @endif
    @if (session('error'))
        <div class="p-4 text-sm text-red-700 bg-red-100 rounded-lg dark:bg-red-900 dark:text-red-300" role="alert">
            {{ session('error') }}
        </div>
    @endif

    <form action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data" class="space-y-12">
        @csrf
        @method('PUT')

        <!-- Main Tab Navigation -->
        <div class="mb-6 border-b border-gray-200 dark:border-gray-700">
            <nav class="-mb-px flex space-x-4 sm:space-x-8" aria-label="Tabs">
                @foreach($mainNavItems as $tabKey => $tabName)
                    <a href="{{ request()->url() }}?tab={{ $tabKey }}{{ ($tabKey === 'application' && $applicationSettingNavItems->isNotEmpty()) ? '&sub_tab=' . $applicationSettingNavItems->keys()->first() : '' }}"
                       @click.prevent="
                           let newMainTab = '{{ $tabKey }}';
                           let newSubTabForUrl = '';
                           activeMainTab = newMainTab;
                           if (newMainTab === 'application') {
                               @if($applicationSettingNavItems->isNotEmpty())
                                   // If current activeSubTab is valid for application, keep it, else default to first
                                   let appSubTabs = {{ json_encode($applicationSettingNavItems->keys()) }};
                                   if (appSubTabs.includes(activeSubTab)) {
                                       newSubTabForUrl = activeSubTab;
                                   } else {
                                       newSubTabForUrl = '{{ $applicationSettingNavItems->keys()->first() }}';
                                   }
                                   activeSubTab = newSubTabForUrl;
                                   window.history.pushState({}, '', `?tab=${newMainTab}&sub_tab=${activeSubTab}`);
                               @else
                                   activeSubTab = '';
                                   window.history.pushState({}, '', `?tab=${newMainTab}`);
                               @endif
                           } else {
                               activeSubTab = '';
                               window.history.pushState({}, '', `?tab=${newMainTab}`);
                           }
                       "
                       :class="{
                           'border-blue-500 text-blue-600 dark:border-blue-400 dark:text-blue-300': activeMainTab === '{{ $tabKey }}',
                           'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-200 dark:hover:border-gray-600': activeMainTab !== '{{ $tabKey }}'
                       }"
                       class="whitespace-nowrap py-3 px-1 border-b-2 font-medium text-sm transition-colors duration-150 ease-in-out">
                        {{ $tabName }}
                    </a>
                @endforeach
            </nav>
        </div>

        <!-- Application Settings Tab Content -->
        <div x-show="activeMainTab === 'application'" class="space-y-10">
            @if($applicationSettingNavItems->isNotEmpty())
                <!-- Sub Tab Navigation for Application Settings -->
                <div class="mb-6 border-b border-gray-200 dark:border-gray-600">
                    <nav class="-mb-px flex space-x-4 sm:space-x-6 overflow-x-auto pb-px" aria-label="Application Setting Groups">
                        @foreach($applicationSettingNavItems as $subTabKey => $subTabName)
                            <a href="{{ request()->url() }}?tab=application&sub_tab={{ $subTabKey }}"
                               @click.prevent="activeSubTab = '{{ $subTabKey }}'; window.history.pushState({}, '', '?tab=application&sub_tab={{ $subTabKey }}')"
                               :class="{
                                   'border-purple-500 text-purple-600 dark:border-purple-400 dark:text-purple-300': activeSubTab === '{{ $subTabKey }}',
                                   'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-200 dark:hover:border-gray-500': activeSubTab !== '{{ $subTabKey }}'
                               }"
                               class="whitespace-nowrap py-2.5 px-1 border-b-2 font-medium text-xs sm:text-sm transition-colors duration-150 ease-in-out">
                                {{ $subTabName }}
                            </a>
                        @endforeach
                    </nav>
                </div>

                {{-- Admin Role Permissions Sub-Tab Content --}}
                @if(Auth::user()->isSuperAdmin() && $applicationSettingNavItems->has('permissions'))
                <div x-show="activeSubTab === 'permissions'" class="space-y-10">
                    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl overflow-hidden">
                        <div class="px-6 py-5 border-b border-gray-200 dark:border-gray-700">
                            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-gray-100">
                                Admin Role Permissions for Setting Groups
                            </h3>
                            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                                Manage 'Admin' role access to all setting groups (Application & Modules).
                            </p>
                        </div>
                        <div class="px-6 py-6">
                            @if(empty($adminSettingPermissions))
                                <p class="text-center text-gray-500 dark:text-gray-400 py-4">No setting groups found to manage permissions for.</p>
                            @else
                                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-6 gap-y-8">
                                    @foreach($adminSettingPermissions as $originalGroupName => $permissions)
                                    <fieldset class="p-4 border border-gray-300 dark:border-gray-700 rounded-lg">
                                        <legend class="text-base font-medium text-gray-900 dark:text-gray-100 px-2 whitespace-normal break-words">
                                            {{ $originalGroupName }}
                                        </legend>
                                        <div class="mt-3 space-y-3">
                                            <div class="flex items-start">
                                                <div class="flex items-center h-5">
                                                    <input id="perm_view_{{ Str::slug($originalGroupName) }}" name="setting_group_permissions[{{ $originalGroupName }}][can_view]" type="checkbox" value="1"
                                                           {{ $permissions['can_view'] ? 'checked' : '' }}
                                                           class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300 dark:border-gray-600 rounded dark:bg-gray-700">
                                                </div>
                                                <div class="ml-3 text-sm">
                                                    <label for="perm_view_{{ Str::slug($originalGroupName) }}" class="font-medium text-gray-700 dark:text-gray-300">Can View</label>
                                                </div>
                                            </div>
                                            <div class="flex items-start">
                                                <div class="flex items-center h-5">
                                                    <input id="perm_edit_{{ Str::slug($originalGroupName) }}" name="setting_group_permissions[{{ $originalGroupName }}][can_edit]" type="checkbox" value="1"
                                                           {{ $permissions['can_edit'] ? 'checked' : '' }}
                                                           class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300 dark:border-gray-600 rounded dark:bg-gray-700">
                                                </div>
                                                <div class="ml-3 text-sm">
                                                    <label for="perm_edit_{{ Str::slug($originalGroupName) }}" class="font-medium text-gray-700 dark:text-gray-300">Can Edit</label>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                @endif

                {{-- Individual Application Setting Group Sub-Tab Content --}}
                @foreach ($applicationSettings as $groupName => $settingsGroupedBySubGroup)
                    <div x-show="activeSubTab === '{{ Str::slug($groupName) }}'" class="space-y-6"> {{-- Reduced space-y for tighter sub-group cards --}}
                        @include('admin.settings.partials.settings-group-card', [
                            'groupDisplayName' => $groupName,
                            'originalGroupName' => $groupName,
                            'settingsGroupedBySubGroup' => $settingsGroupedBySubGroup, // Pass the sub-grouped settings
                            'groupDescription' => $groupDescriptions[$groupName] ?? 'Manage ' . strtolower($groupName) . ' settings.',
                            'canEditGroup' => Auth::user()->isSuperAdmin() || (Auth::user()->hasRole('admin') && \App\Models\SettingGroupPermission::where('role_name', 'admin')->where('setting_group_name', $groupName)->where('can_edit', true)->exists())
                        ])

                        {{-- Test Mail Section - Placed within Mail Settings Sub-Tab --}}
                        @if(Str::slug($groupName) === 'mail-settings')
                            @php
                                $canViewMailSettings = Auth::user()->isSuperAdmin() || (Auth::user()->hasRole('admin') && \App\Models\SettingGroupPermission::where('role_name', 'admin')->where('setting_group_name', 'Mail Settings')->where('can_view', true)->exists());
                            @endphp
                            @if($canViewMailSettings)
                            <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl overflow-hidden">
                                <div class="px-6 py-5 border-b border-gray-200 dark:border-gray-700">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-gray-100">
                                        Test Mail Configuration
                                    </h3>
                                </div>
                                <div class="px-6 py-6">
                                    <p class="text-sm text-gray-600 dark:text-gray-400 mb-5">
                                        Send a test email to your logged-in email address (<span class="font-medium">{{ Auth::user()->email }}</span>) to verify mail settings.
                                    </p>
                                    <div class="flex items-center">
                                        <button type="button" id="sendTestMailBtn"
                                                class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 dark:bg-green-500 dark:hover:bg-green-600 border border-transparent rounded-lg font-semibold text-xs text-white uppercase tracking-widest focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                                            Send Test Email
                                        </button>
                                        <div id="testMailStatus" class="ml-4 text-sm"></div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        @endif
                    </div>
                @endforeach
            @elseif(Auth::user()->isSuperAdmin() && empty($adminSettingPermissions) && $applicationSettings->isEmpty())
                <p class="text-center text-gray-500 dark:text-gray-400 py-8">No application settings available or you do not have permission to view them.</p>
            @else
                <p class="text-center text-gray-500 dark:text-gray-400 py-8">No application settings groups are available for you to view or manage.</p>
            @endif
        </div>

        <!-- Module Settings Tabs Content -->
        @foreach($moduleSettings as $moduleDisplayName => $groupsInModule)
            <div x-show="activeMainTab === '{{ Str::slug($moduleDisplayName) }}'" class="space-y-10">
                @if($groupsInModule->isEmpty())
                    <p class="text-center text-gray-500 dark:text-gray-400 py-8">No setting groups available for the {{ $moduleDisplayName }} module or you do not have permission to view them.</p>
                @else
                    @foreach ($groupsInModule as $groupNameInModule => $settingsInGroup)
                        @php
                            // Reconstruct the original group name for permission checking
                            // This assumes module keys are simple strings without '::'
                            // If module keys can contain '::', this logic needs adjustment or a direct mapping from controller.
                            $moduleInstance = \Nwidart\Modules\Facades\Module::findBy('display_name', $moduleDisplayName);
                            $moduleKey = $moduleInstance ? $moduleInstance->getName() : Str::slug($moduleDisplayName, '_'); // Fallback to slug if not found
                            $originalGroupNameForPerms = $moduleKey . '::' . $groupNameInModule;
                        @endphp
                        @include('admin.settings.partials.settings-group-card', [
                            'groupDisplayName' => $groupNameInModule, // Display name for the card header within the module tab
                            'originalGroupName' => $originalGroupNameForPerms, // The actual group key for permissions
                            'settingsGroupedBySubGroup' => $settingsInGroup, // This is already sub-grouped from controller
                            'groupDescription' => $groupDescriptions[$originalGroupNameForPerms] ?? 'Manage ' . strtolower($groupNameInModule) . ' settings for ' . $moduleDisplayName . '.',
                            'canEditGroup' => Auth::user()->isSuperAdmin() || (Auth::user()->hasRole('admin') && \App\Models\SettingGroupPermission::where('role_name', 'admin')->where('setting_group_name', $originalGroupNameForPerms)->where('can_edit', true)->exists())
                        ])
                    @endforeach
                @endif
            </div>
        @endforeach

        <!-- Save All Settings Button (Common for all tabs) -->
        <div class="pt-8">
            <div class="flex justify-start">
                <button type="submit" class="inline-flex justify-center py-2.5 px-6 border border-transparent shadow-sm text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:bg-blue-500 dark:hover:bg-blue-600 dark:focus:ring-offset-gray-800 transition-colors">
                    Save All Settings
                </button>
            </div>
        </div>

    </form>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    const sendTestMailBtn = document.getElementById('sendTestMailBtn');
    const testMailStatus = document.getElementById('testMailStatus');

    if (sendTestMailBtn) {
        sendTestMailBtn.addEventListener('click', function () {
            sendTestMailBtn.disabled = true;
            sendTestMailBtn.classList.add('opacity-50', 'cursor-not-allowed');
            testMailStatus.textContent = 'Sending test email...';
            testMailStatus.className = 'mt-3 text-sm text-gray-600 dark:text-gray-400';


            fetch('{{ route('admin.settings.testMail') }}', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Accept': 'application/json',
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    testMailStatus.textContent = 'Success: ' + data.message;
                    testMailStatus.className = 'mt-3 text-sm text-green-600 dark:text-green-400';
                } else {
                    testMailStatus.textContent = 'Error: ' + (data.message || 'Failed to send test email.');
                    testMailStatus.className = 'mt-3 text-sm text-red-600 dark:text-red-400';
                }
            })
            .catch(error => {
                console.error('Error:', error);
                testMailStatus.textContent = 'Error: An unexpected error occurred.';
                testMailStatus.className = 'mt-3 text-sm text-red-600 dark:text-red-400';
            })
            .finally(() => {
                sendTestMailBtn.disabled = false;
                sendTestMailBtn.classList.remove('opacity-50', 'cursor-not-allowed');
            });
        });
    }
});
</script>
@endpush
@endsection
