@extends('layouts.admin')

@section('title', 'Manage Roles')
@section('header_title', 'User Roles')

@section('content')
<div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
    <div class="p-6 lg:p-8">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-2xl font-semibold text-gray-900 dark:text-gray-100">Roles</h3>
            <a href="{{ route('admin.roles.create') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring ring-blue-300 disabled:opacity-25 transition ease-in-out duration-150">
                Create New Role
            </a>
        </div>

        @include('admin.partials.alerts')

        @if($roles->isEmpty())
            <p class="text-gray-600 dark:text-gray-400">No roles found. Create one to get started!</p>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Name</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Guard</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Users</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Permissions</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Module Access</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Setting Group Access</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Show on Reg.</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach ($roles as $role)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-gray-100 align-top">{{ $role->name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 align-top">{{ $role->guard_name }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 align-top">{{ $role->users_count }}</td>
                                <td class="px-6 py-4 text-sm text-gray-500 dark:text-gray-400 align-top">
                                    @if($role->permissions->count() > 0)
                                        @php $spatiePermissions = $role->permissions->pluck('name'); @endphp
                                        {{ $spatiePermissions->take(2)->implode(', ') }}
                                        @if($spatiePermissions->count() > 2)
                                            <span class="text-xs cursor-pointer text-blue-500" title="{{ $spatiePermissions->implode(', ') }}">... ({{ $spatiePermissions->count() }} total)</span>
                                        @endif
                                    @else
                                        No permissions assigned
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-500 dark:text-gray-400 align-top">
                                    @if(!empty($role->module_access_permissions))
                                        @php $modulePerms = collect($role->module_access_permissions); @endphp
                                        {{ $modulePerms->take(2)->implode(', ') }}
                                        @if($modulePerms->count() > 2)
                                        <span class="text-xs cursor-pointer text-blue-500" title="{{ $modulePerms->implode(', ') }}">... ({{ $modulePerms->count() }} total)</span>
                                        @endif
                                    @else
                                        No modules assigned
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-500 dark:text-gray-400 align-top">
                                    @if(!empty($role->setting_group_access_summary))
                                        @php $settingGroupPerms = collect($role->setting_group_access_summary); @endphp
                                        {{ $settingGroupPerms->take(2)->implode(', ') }}
                                        @if($settingGroupPerms->count() > 2)
                                        <span class="text-xs cursor-pointer text-blue-500" title="{{ $settingGroupPerms->implode(', ') }}">... ({{ $settingGroupPerms->count() }} total)</span>
                                        @endif
                                    @else
                                        No setting groups
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400 align-top">
                                    {{ $role->show_on_registration ? 'Yes' : 'No' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium align-top">
                                    <a href="{{ route('admin.roles.edit', $role) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-600 mr-3">Edit</a>
                                    @if(!in_array($role->name, ['super_admin', 'admin', 'user'])) {{-- Prevent deleting core roles --}}
                                        <form action="{{ route('admin.roles.destroy', $role) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this role? This action cannot be undone.');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-600">Delete</button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                {{ $roles->links() }}
            </div>
        @endif
    </div>
</div>
@endsection