<div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Role Name</label>
        <input type="text" name="name" id="name" value="{{ old('name', $role->name ?? '') }}" required
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
        @error('name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
    </div>
    <div class="flex items-center mt-2">
        <input id="show_on_registration" name="show_on_registration" type="checkbox" value="1"
               {{ old('show_on_registration', (isset($role) && $role->show_on_registration) ? '1' : '') == '1' ? 'checked' : '' }}
               class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-500 rounded dark:bg-gray-700">
        <label for="show_on_registration" class="ml-2 block text-sm text-gray-900 dark:text-gray-100">
            Show this role on user registration form
        </label>
        @error('show_on_registration') <p class="text-red-500 text-xs ml-2">{{ $message }}</p> @enderror
    </div>
</div>

<div class="mt-6">
    <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-3">Permissions</h3>
    @if(empty($permissions))
        <p class="text-sm text-gray-500 dark:text-gray-400">No permissions defined yet. You can create permissions via seeds or another admin interface.</p>
    @else
        <div class="space-y-4">
            @foreach($permissions as $group => $groupPermissions)
                <fieldset class="border border-gray-300 dark:border-gray-600 p-4 rounded-md">
                    <legend class="text-md font-medium text-gray-800 dark:text-gray-200 px-2">{{ Str::title(str_replace(['_', '-'], ' ', $group)) }}</legend>
                    <div class="mt-3 grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
                        @foreach($groupPermissions as $permission)
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="permission_{{ $permission->id }}" name="permissions[]" type="checkbox" value="{{ $permission->id }}"
                                           {{ (isset($rolePermissions) && in_array($permission->id, $rolePermissions)) ? 'checked' : '' }}
                                           class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-500 rounded dark:bg-gray-700">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="permission_{{ $permission->id }}" class="font-medium text-gray-700 dark:text-gray-300">{{ $permission->name }}</label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </fieldset>
            @endforeach
        </div>
        @error('permissions') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        @error('permissions.*') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
    @endif
</div>

{{-- Show Module and Setting Group permissions for new roles, or existing roles other than super_admin --}}
@if( (isset($role) && $role->name !== 'super_admin') || !isset($role->name) ) {{-- !isset($role->name) covers the create case --}}
    <div class="mt-8">
        <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-3">Module Access Permissions</h3>
        @if(isset($allModules) && count($allModules) > 0)
            <fieldset class="border border-gray-300 dark:border-gray-600 p-4 rounded-md">
                <legend class="text-md font-medium text-gray-800 dark:text-gray-200 px-2">Grant Access to Modules</legend>
                <div class="mt-3 grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
                    @foreach($allModules as $module)
                        <div class="flex items-start">
                            <div class="flex items-center h-5">
                                <input id="module_access_{{ $module->getLowerName() }}" name="module_access[]" type="checkbox" value="{{ $module->getName() }}"
                                       {{ (isset($roleModulePermissions) && in_array($module->getName(), $roleModulePermissions)) ? 'checked' : '' }}
                                       class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-500 rounded dark:bg-gray-700">
                            </div>
                            <div class="ml-3 text-sm">
                                <label for="module_access_{{ $module->getLowerName() }}" class="font-medium text-gray-700 dark:text-gray-300">{{ $module->get('display_name', $module->getName()) }}</label>
                                <p class="text-xs text-gray-500 dark:text-gray-400">{{ $module->get('description', 'No description') }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </fieldset>
            @error('module_access.*') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        @else
            <p class="text-sm text-gray-500 dark:text-gray-400">No modules available to assign permissions.</p>
        @endif
    </div>

    <div class="mt-8">
        <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100 mb-3">Setting Group Access Permissions</h3>
        @if(isset($allSettingGroups) && $allSettingGroups->isNotEmpty())
            <div class="space-y-4">
                @foreach($allSettingGroups as $groupName)
                    @php
                        $currentPerms = $roleSettingGroupPermissions[$groupName] ?? null;
                    @endphp
                    <fieldset class="border border-gray-300 dark:border-gray-600 p-4 rounded-md">
                        <legend class="text-md font-medium text-gray-800 dark:text-gray-200 px-2">{{ $groupName }}</legend>
                        <div class="mt-3 grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="setting_group_{{ Str::slug($groupName) }}_view" name="setting_group_permissions[{{ $groupName }}][can_view]" type="checkbox" value="1"
                                           {{ ($currentPerms && $currentPerms->can_view) ? 'checked' : '' }}
                                           class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-500 rounded dark:bg-gray-700">
                                </div>
                                <label for="setting_group_{{ Str::slug($groupName) }}_view" class="ml-3 block text-sm font-medium text-gray-700 dark:text-gray-300">Can View</label>
                            </div>
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="setting_group_{{ Str::slug($groupName) }}_edit" name="setting_group_permissions[{{ $groupName }}][can_edit]" type="checkbox" value="1"
                                           {{ ($currentPerms && $currentPerms->can_edit) ? 'checked' : '' }}
                                           class="focus:ring-indigo-500 h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-500 rounded dark:bg-gray-700">
                                </div>
                                <label for="setting_group_{{ Str::slug($groupName) }}_edit" class="ml-3 block text-sm font-medium text-gray-700 dark:text-gray-300">Can Edit</label>
                            </div>
                        </div>
                    </fieldset>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500 dark:text-gray-400">No setting groups found.</p>
        @endif
    </div>
@endif

<div class="mt-8 flex justify-end">
    <a href="{{ route('admin.roles.index') }}" class="bg-white dark:bg-gray-700 py-2 px-4 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 mr-3">
        Cancel
    </a>
    <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800">
        {{ isset($role) && $role->exists ? 'Update Role' : 'Create Role' }}
    </button>
</div>