<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Payment Gateways Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-6 lg:p-8 bg-white dark:bg-gray-800 dark:bg-gradient-to-bl dark:from-gray-700/50 dark:via-transparent border-b border-gray-200 dark:border-gray-700">
                    <h1 class="text-2xl font-medium text-gray-900 dark:text-white">
                        Installed Payment Gateways
                    </h1>

                    <p class="mt-2 text-gray-600 dark:text-gray-400">
                        Below is a list of all installed and enabled payment gateway modules. You can manage their individual settings from their respective configuration pages.
                    </p>
                </div>

                <div class="bg-gray-200 dark:bg-gray-800 bg-opacity-25 p-6 lg:p-8">
                    @if($paymentGatewayModules->isNotEmpty())
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            @foreach($paymentGatewayModules as $module)
                                @php
                                    $adminMenu = $module->get('admin_menu');
                                    $settingsRoute = '#';
                                    if ($adminMenu && isset($adminMenu['route_name']) && Route::has($adminMenu['route_name'])) {
                                        $settingsRoute = route($adminMenu['route_name']);
                                    } elseif ($adminMenu && isset($adminMenu['children'][0]['route_name']) && Route::has($adminMenu['children'][0]['route_name'])) {
                                        // Fallback to first child if main route_name isn't the direct settings link
                                        $settingsRoute = route($adminMenu['children'][0]['route_name']);
                                    }
                                @endphp
                                <div class="p-6 bg-white dark:bg-gray-700 shadow rounded-lg flex flex-col justify-between">
                                    <div>
                                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">{{ $module->get('display_name', $module->getName()) }}</h3>
                                        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">{{ $module->getDescription() }}</p>
                                    </div>
                                    <div class="mt-4">
                                        <a href="{{ $settingsRoute }}" class="text-sm font-medium text-indigo-600 dark:text-indigo-400 hover:text-indigo-500 dark:hover:text-indigo-300">
                                            Configure &rarr;
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-gray-600 dark:text-gray-400">No payment gateway modules are currently enabled.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>