@php
use Nwidart\Modules\Facades\Module;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Models\ModulePermission;
use Illuminate\Support\Str;

$currentUser = Auth::user();
$paymentGatewaySidebarModules = [];
$otherSidebarModules = [];
$installedPaymentGatewaysExist = false; // For the "Payment Gateways Dashboard" link

if ($currentUser && class_exists(Module::class)) {
    $allEnabledModules = Module::allEnabled();

    foreach ($allEnabledModules as $module) {
        $adminMenuConfig = $module->get('admin_menu');
        $moduleName = $module->getName(); // Canonical module name
        $moduleCategory = $module->get('category');

        if ($adminMenuConfig && isset($adminMenuConfig['route_name']) && Route::has($adminMenuConfig['route_name'])) {
            if ($moduleCategory === 'payment_gateway') {
                $installedPaymentGatewaysExist = true; // Set flag if any payment gateway is found
            }

            $canShow = false;
            if ($currentUser->isSuperAdmin()) {
                $canShow = true;
            } elseif ($currentUser->hasRole('admin')) {
                $hasModulePermission = ModulePermission::where('role_name', 'admin')
                                                       ->where('module_name', $moduleName)
                                                       ->exists();
                
                $spatiePermissionRequired = $adminMenuConfig['permissions'] ?? null;
                $hasSpatiePermission = true; // Assume true (no specific Spatie permission needed or list is empty)
                
                // Only perform Spatie permission check if $spatiePermissionRequired is non-null AND non-empty
                if (!is_null($spatiePermissionRequired) && !empty($spatiePermissionRequired)) {
                    $hasSpatiePermission = is_array($spatiePermissionRequired)
                                           ? $currentUser->hasAnyPermission($spatiePermissionRequired) // For an array of permissions
                                           : $currentUser->can($spatiePermissionRequired); // For a single permission string
                }

                $canShow = $hasModulePermission && $hasSpatiePermission;
            }

            if ($canShow) {
                $moduleData = [
                    'title' => $adminMenuConfig['title'] ?? $module->getName(),
                    'route_name' => $adminMenuConfig['route_name'],
                    'icon_svg_path' => $adminMenuConfig['icon_svg_path'] ?? 'M8.25 6.75h7.5M8.25 12h7.5m-7.5 5.25h7.5M3.75 6.75h.007v.008H3.75V6.75zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zM3.75 12h.007v.008H3.75V12zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm-.375 5.25h.007v.008H3.75v-.008zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z', // Default icon
                    'order' => $adminMenuConfig['order'] ?? 999,
                    'name' => $module->getName(), // For active route checking
                ];

                if ($moduleCategory === 'payment_gateway') {
                    $paymentGatewaySidebarModules[] = $moduleData;
                } else {
                    $otherSidebarModules[] = $moduleData;
                }
            }
        }
    }

    // Sort modules by order, then by title
    $sortModules = function ($a, $b) {
        if ($a['order'] == $b['order']) {
            return strcmp($a['title'], $b['title']);
        }
        return $a['order'] < $b['order'] ? -1 : 1;
    };

    usort($paymentGatewaySidebarModules, $sortModules);
    usort($otherSidebarModules, $sortModules);
}

// Determine SAAS dropdown visibility and active state
$showSaasDropdown = false;
$isSaasRouteActive = false;

$subscriptionsEnabled = function_exists('setting') && setting('subscriptions_enabled', '0') == '1';
$creditsSystemEnabled = function_exists('setting') && setting('credits_system_enabled', '0') == '1';
$walletSystemEnabled = function_exists('setting') && setting('wallet_system_enabled', '0') == '1';

if ($subscriptionsEnabled) {
    $showSaasDropdown = true;
    if (request()->routeIs('admin.subscription-plans.*')) $isSaasRouteActive = true;
}
if ($currentUser->isSuperAdmin()) {
    if ($creditsSystemEnabled) {
        $showSaasDropdown = true;
        if (request()->routeIs('admin.feature-credit-costs.*') || request()->routeIs('admin.credit-transactions.*')) $isSaasRouteActive = true;
    }
    if ($walletSystemEnabled) {
        $showSaasDropdown = true;
        if (request()->routeIs('admin.wallet-transactions.*')) $isSaasRouteActive = true;
    }
}

// Determine if the payment gateway dropdown should be open
$isPaymentGatewayRouteActive = false;
foreach ($paymentGatewaySidebarModules as $pgModule) {
    if (request()->routeIs('admin.' . Str::kebab($pgModule['name']) . '.*') || request()->routeIs($pgModule['route_name'].'*')) {
        $isPaymentGatewayRouteActive = true;
        break;
    }
}
@endphp

<!-- Sidebar backdrop (for mobile) -->
<div x-show="sidebarOpen && window.innerWidth < 768" @click="sidebarOpen = false" class="fixed inset-0 z-10 bg-black bg-opacity-50 md:hidden" style="display: none;"></div>

<aside
    x-show="sidebarOpen || window.innerWidth >= 768"
    x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="-translate-x-full"
    x-transition:enter-end="translate-x-0"
    x-transition:leave="transition ease-in duration-300"
    x-transition:leave-start="translate-x-0"
    x-transition:leave-end="-translate-x-full"
    :class="{
        'translate-x-0': sidebarOpen && window.innerWidth < 768,
        '-translate-x-full': !sidebarOpen && window.innerWidth < 768,
        'md:w-64': !sidebarMinimized && window.innerWidth >= 768,
        'md:w-20': sidebarMinimized && window.innerWidth >= 768,
        'w-64': window.innerWidth < 768,
        'p-4': !sidebarMinimized || window.innerWidth < 768,
        'p-2': sidebarMinimized && window.innerWidth >= 768,
    }"
    class="fixed inset-y-0 left-0 z-20 space-y-6 overflow-y-auto 
           bg-white text-gray-700 dark:bg-gray-800 dark:text-gray-200 
           md:relative md:translate-x-0 md:w-64 p-4"
    <!-- Logo or App Name -->
    <a href="{{ route('admin.dashboard') }}" 
       class="flex items-center text-inherit"
       :class="{'justify-center': sidebarMinimized && window.innerWidth >= 768, 'px-2 py-2': !sidebarMinimized || window.innerWidth < 768 }">
        <img src="{{ setting('site_logo') ? Storage::url(setting('site_logo')) : asset('/images/default-logo.png') }}" 
             alt="{{ setting('site_name', config('app.name')) }} Logo" 
             class="h-8 w-auto"
             :class="{'mr-2': !sidebarMinimized || window.innerWidth < 768}">
        <span class="text-lg font-bold" x-show="!sidebarMinimized || window.innerWidth < 768">{{ setting('site_name', config('app.name')) }}</span>
    </a>

    <nav class="space-y-1">
        <x-admin.nav-link :href="route('admin.dashboard')" 
                          :active="request()->routeIs('admin.dashboard')" 
                          class="py-2" 
                          x-bind:class="{
                              'px-3': !sidebarMinimized || window.innerWidth < 768,
                              'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                          }">
            <svg class="w-5 h-5 shrink-0" 
                 :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                 fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Dashboard</span>
        </x-admin.nav-link>

        {{-- Static Admin Links --}}
        <x-admin.nav-link :href="route('admin.users.index')" 
                          :active="request()->routeIs('admin.users.*')" 
                          class="py-2" 
                          x-bind:class="{
                              'px-3': !sidebarMinimized || window.innerWidth < 768,
                              'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                          }">
            <svg class="w-5 h-5 shrink-0" 
                 :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                 fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Users</span>
        </x-admin.nav-link>
        <x-admin.nav-link :href="route('admin.roles.index')" 
                          :active="request()->routeIs('admin.roles.*')" 
                          class="py-2" 
                          x-bind:class="{
                              'px-3': !sidebarMinimized || window.innerWidth < 768,
                              'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                          }">
            <svg class="w-5 h-5 shrink-0" 
                 :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                 fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.75 5.25a3 3 0 013 3m3 0a6 6 0 01-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1121.75 8.25z"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Roles & Permissions</span>
        </x-admin.nav-link>
        <x-admin.nav-link :href="route('admin.settings.index')" 
                          :active="request()->routeIs('admin.settings.*')" 
                          class="py-2" 
                          x-bind:class="{
                              'px-3': !sidebarMinimized || window.innerWidth < 768,
                              'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                          }">
            <svg class="w-5 h-5 shrink-0" 
                 :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                 fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066 2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065zM15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Settings</span>
        </x-admin.nav-link>
        <x-admin.nav-link :href="route('admin.modules.index')" 
                          :active="request()->routeIs('admin.modules.*')" 
                          class="py-2" 
                          x-bind:class="{
                              'px-3': !sidebarMinimized || window.innerWidth < 768,
                              'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                          }">
            <svg class="w-5 h-5 shrink-0" 
                 :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                 fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6zM3.75 15.75A2.25 2.25 0 016 13.5h2.25a2.25 2.25 0 012.25 2.25V18a2.25 2.25 0 01-2.25 2.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25H18A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25A2.25 2.25 0 0113.5 8.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Modules</span>
        </x-admin.nav-link>

 {{-- News Letters Management Dropdown --}}
        @if($showSaasDropdown)
        <li x-data="{ open: {{ json_encode($isSaasRouteActive) }} }" class="list-none">
            <button @click="open = !open" 
                    class="flex items-center justify-between w-full text-sm font-medium rounded-md 
                           text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 
                           hover:text-gray-900 dark:hover:text-white transition-colors duration-150 py-2 group"
                    x-bind:class="{
                        'px-3': !sidebarMinimized || window.innerWidth < 768,
                        'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768,
                        'bg-gray-100 dark:bg-gray-700': open && (!sidebarMinimized || window.innerWidth < 768)
                    }">
                <div class="flex items-center">
                    <svg class="w-5 h-5 shrink-0" 
                 :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }"
                 fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
             <span x-show="!sidebarMinimized || window.innerWidth < 768">News Letters</span>
                </div>
                <svg x-show="!sidebarMinimized || window.innerWidth < 768" class="w-4 h-4 shrink-0 ml-auto transition-transform duration-200" :class="{'rotate-90': open, 'text-gray-500 group-hover:text-gray-700 dark:text-gray-400 dark:group-hover:text-gray-200': true }" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
            </button>
            <ul x-show="open && (!sidebarMinimized || window.innerWidth < 768)" x-transition class="mt-1 space-y-1" 
                :class="{'pl-5': !sidebarMinimized || window.innerWidth < 768, 'hidden': sidebarMinimized && window.innerWidth >= 768 }">
             
        @if(Auth::user()->isSuperAdmin() || Auth::user()->can('manage newsletter'))
        <x-admin.nav-link :href="route('admin.newsletter-subscriptions.index')"
                          :active="request()->routeIs('admin.newsletter-subscriptions.*')"
                          class="py-2"
                          x-bind:class="{
                              'px-3': !sidebarMinimized || window.innerWidth < 768,
                              'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                          }">
            <svg class="w-5 h-5 shrink-0" 
                 :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }"
                 fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Subscribers</span>
        </x-admin.nav-link>
        @endif
        
        {{-- Newsletter Management (Composing/Sending) --}}
        @if(Auth::user()->isSuperAdmin() || Auth::user()->can('manage newsletters')) {{-- New permission --}}
        <x-admin.nav-link :href="route('admin.newsletters.index')"
                          :active="request()->routeIs('admin.newsletters.*')"
                          class="py-2"
                          x-bind:class="{
                              'px-3': !sidebarMinimized || window.innerWidth < 768,
                              'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                          }">
            <svg class="w-5 h-5 shrink-0" :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Manage Newsletters</span>
        </x-admin.nav-link>
        @endif

            </ul>
        </li>
        @endif

        {{-- SAAS Management Dropdown --}}
        @if($showSaasDropdown)
        <li x-data="{ open: {{ json_encode($isSaasRouteActive) }} }" class="list-none">
            <button @click="open = !open" 
                    class="flex items-center justify-between w-full text-sm font-medium rounded-md 
                           text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 
                           hover:text-gray-900 dark:hover:text-white transition-colors duration-150 py-2 group"
                    x-bind:class="{
                        'px-3': !sidebarMinimized || window.innerWidth < 768,
                        'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768,
                        'bg-gray-100 dark:bg-gray-700': open && (!sidebarMinimized || window.innerWidth < 768)
                    }">
                <div class="flex items-center">
                    <svg class="w-5 h-5 shrink-0" 
                         :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg> {{-- Briefcase Icon --}}
                    <span x-show="!sidebarMinimized || window.innerWidth < 768">SAAS</span>
                </div>
                <svg x-show="!sidebarMinimized || window.innerWidth < 768" class="w-4 h-4 shrink-0 ml-auto transition-transform duration-200" :class="{'rotate-90': open, 'text-gray-500 group-hover:text-gray-700 dark:text-gray-400 dark:group-hover:text-gray-200': true }" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
            </button>
            <ul x-show="open && (!sidebarMinimized || window.innerWidth < 768)" x-transition class="mt-1 space-y-1" 
                :class="{'pl-5': !sidebarMinimized || window.innerWidth < 768, 'hidden': sidebarMinimized && window.innerWidth >= 768 }">
                @if($subscriptionsEnabled)
                <li class="list-none">
                    <x-admin.nav-link :href="route('admin.subscription-plans.index')" 
                                      :active="request()->routeIs('admin.subscription-plans.*')" 
                                      class="py-2 text-xs"
                                      x-bind:class="{ 'px-3': !sidebarMinimized || window.innerWidth < 768, 'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768 }">
                        <svg class="w-4 h-4 shrink-0" :class="{ 'mr-2': !sidebarMinimized || window.innerWidth < 768 }" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.25 8.25h19.5M2.25 9h19.5m-16.5 5.25h6m-6 2.25h3m-3.75 3h15a2.25 2.25 0 002.25-2.25V6.75A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25v10.5A2.25 2.25 0 004.5 19.5z"></path></svg>
                        <span x-show="!sidebarMinimized || window.innerWidth < 768">Subscription Plans</span>
                    </x-admin.nav-link>
                </li>
                @endif
                @if($currentUser->isSuperAdmin() && $creditsSystemEnabled)
                <li class="list-none">
                    <x-admin.nav-link :href="route('admin.feature-credit-costs.index')"
                                      :active="request()->routeIs('admin.feature-credit-costs.*')"
                                      class="py-2 text-xs"
                                      x-bind:class="{ 'px-3': !sidebarMinimized || window.innerWidth < 768, 'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768 }">
                        <svg class="w-4 h-4 shrink-0" :class="{ 'mr-2': !sidebarMinimized || window.innerWidth < 768 }" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>
                        <span x-show="!sidebarMinimized || window.innerWidth < 768">Feature Costs</span>
                    </x-admin.nav-link>
                </li>
                <li class="list-none">
                    <x-admin.nav-link :href="route('admin.credit-transactions.index')"
                                      :active="request()->routeIs('admin.credit-transactions.*')" 
                                      class="py-2 text-xs"
                                      x-bind:class="{ 'px-3': !sidebarMinimized || window.innerWidth < 768, 'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768 }">
                        <svg class="w-4 h-4 shrink-0" :class="{ 'mr-2': !sidebarMinimized || window.innerWidth < 768 }" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a2.25 2.25 0 00-2.25-2.25H5.25A2.25 2.25 0 003 12m18 0v6.25A2.25 2.25 0 0118.75 21H5.25A2.25 2.25 0 013 18.25V12m18 0V5.75A2.25 2.25 0 0018.75 3H5.25A2.25 2.25 0 003 5.75V12m15-7.5h-9M15 3V1.5M9 3V1.5m6 19.5V21m-6 .75V21m9-9.75H6.375"></path></svg>
                        <span x-show="!sidebarMinimized || window.innerWidth < 768">Credit Transactions</span>
                    </x-admin.nav-link>
                </li>
                @endif
                @if($currentUser->isSuperAdmin() && $walletSystemEnabled)
                <li class="list-none">
                    <x-admin.nav-link :href="route('admin.wallet-transactions.index')"
                                      :active="request()->routeIs('admin.wallet-transactions.*')" 
                                      class="py-2 text-xs"
                                      x-bind:class="{ 'px-3': !sidebarMinimized || window.innerWidth < 768, 'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768 }">
                        <svg class="w-4 h-4 shrink-0" :class="{ 'mr-2': !sidebarMinimized || window.innerWidth < 768 }" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.25 18.75a60.07 60.07 0 0115.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 013 6A.75.75 0 012.25 5.25V4.5m0 13.5V12A2.25 2.25 0 004.5 9.75h15A2.25 2.25 0 0021.75 12v6.25a2.25 2.25 0 00-2.25 2.25H15M12 12.75a.75.75 0 01.75-.75h3a.75.75 0 010 1.5h-3a.75.75 0 01-.75-.75z"></path></svg>
                        <span x-show="!sidebarMinimized || window.innerWidth < 768">Wallet Transactions</span>
                    </x-admin.nav-link>
                </li>
                <li class="list-none">
                    <x-admin.nav-link :href="route('admin.wallet-withdrawal-requests.index')"
                                      :active="request()->routeIs('admin.wallet-withdrawal-requests.*')" 
                                      class="py-2 text-xs"
                                      x-bind:class="{ 'px-3': !sidebarMinimized || window.innerWidth < 768, 'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768 }">
                        <svg class="w-4 h-4 shrink-0" :class="{ 'mr-2': !sidebarMinimized || window.innerWidth < 768 }" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path></svg>
                        <span x-show="!sidebarMinimized || window.innerWidth < 768">Withdrawal Requests</span>
                    </x-admin.nav-link>
                </li>
                @endif
            </ul>
        </li>
        @endif

        <x-admin.nav-link :href="route('admin.tickets.index')" 
                          :active="request()->routeIs('admin.tickets.*')" 
                          class="py-2" 
                          x-bind:class="{
                              'px-3': !sidebarMinimized || window.innerWidth < 768,
                              'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                          }">
            <svg class="w-5 h-5 shrink-0" 
                 :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                 fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 002 2h1c1.105 0 2-.895 2-2v-1a2 2 0 00-2-2H5zM5 14a2 2 0 00-2 2v3a2 2 0 002 2h1c1.105 0 2-.895 2-2v-1a2 2 0 00-2-2H5z"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Support Tickets</span>
        </x-admin.nav-link>
        <x-admin.nav-link :href="route('admin.notifications.index')" 
                          :active="request()->routeIs('admin.notifications.*')" 
                          class="py-2" 
                          x-bind:class="{
                              'px-3': !sidebarMinimized || window.innerWidth < 768,
                              'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                          }">
            <svg class="w-5 h-5 shrink-0" 
                 :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                 fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.857 17.082a23.848 23.848 0 005.454-1.31A8.967 8.967 0 0118 9.75v-.7V9A6 6 0 006 9v.75a8.967 8.967 0 01-2.312 6.022c1.733.64 3.56 1.085 5.455 1.31m5.714 0a24.255 24.255 0 01-5.714 0m5.714 0a3 3 0 11-5.714 0"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Notifications</span>
        </x-admin.nav-link>

        {{-- Payment Gateway Section --}}
        @if($installedPaymentGatewaysExist || !empty($paymentGatewaySidebarModules))

            @if(!empty($paymentGatewaySidebarModules))
            <li x-data="{ open: {{ json_encode($isPaymentGatewayRouteActive) }} }" class="list-none">
                <button @click="open = !open" 
                        class="flex items-center justify-between w-full text-sm font-medium rounded-md 
                               text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 
                               hover:text-gray-900 dark:hover:text-white transition-colors duration-150 py-2 group"
                        x-bind:class="{
                            'px-3': !sidebarMinimized || window.innerWidth < 768,
                            'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768,
                            'bg-gray-100 dark:bg-gray-700': open && (!sidebarMinimized || window.innerWidth < 768)
                        }">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 shrink-0" 
                             :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                             fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                        <span x-show="!sidebarMinimized || window.innerWidth < 768">Payment Gateways</span>
                    </div>
                    <svg x-show="!sidebarMinimized || window.innerWidth < 768" class="w-4 h-4 shrink-0 ml-auto transition-transform duration-200" :class="{'rotate-90': open, 'text-gray-500 group-hover:text-gray-700 dark:text-gray-400 dark:group-hover:text-gray-200': true }" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
                </button>
                <ul x-show="open && (!sidebarMinimized || window.innerWidth < 768)" x-transition class="mt-1 space-y-1" 
                    :class="{'pl-5': !sidebarMinimized || window.innerWidth < 768, 'hidden': sidebarMinimized && window.innerWidth >= 768 }">
                    @foreach($paymentGatewaySidebarModules as $moduleItem)
                        <li class="list-none">
                            <x-admin.nav-link :href="route($moduleItem['route_name'])" 
                                              :active="request()->routeIs('admin.' . Str::kebab($moduleItem['name']) . '.*') || request()->routeIs($moduleItem['route_name'].'*')" 
                                              class="py-2 text-xs"
                                              x-bind:class="{
                                                  'px-3': !sidebarMinimized || window.innerWidth < 768,
                                                  'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                                              }">
                                <svg class="w-4 h-4 shrink-0" 
                                     :class="{ 'mr-2': !sidebarMinimized || window.innerWidth < 768 }" 
                                     fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $moduleItem['icon_svg_path'] }}"></path></svg>
                                <span x-show="!sidebarMinimized || window.innerWidth < 768">{{ $moduleItem['title'] }}</span>
                            </x-admin.nav-link>
                        </li>
                    @endforeach
                </ul>
            </li>
            @endif
        @endif

        {{-- Other Modules Section --}}
        @if(!empty($otherSidebarModules))
            <div class="pt-2 mt-2 border-t border-gray-200 dark:border-gray-700"></div>
            <p x-show="!sidebarMinimized || window.innerWidth < 768" class="px-3 py-2 text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                Applications & Modules
            </p>
            @foreach($otherSidebarModules as $moduleItem)
                <x-admin.nav-link :href="route($moduleItem['route_name'])" 
                                  :active="request()->routeIs('admin.' . Str::kebab($moduleItem['name']) . '.*') || request()->routeIs($moduleItem['route_name'].'*')" 
                                  class="py-2" 
                                  x-bind:class="{
                                      'px-3': !sidebarMinimized || window.innerWidth < 768,
                                      'px-2 justify-center': sidebarMinimized && window.innerWidth >= 768
                                  }">
                    <svg class="w-5 h-5 shrink-0" 
                         :class="{ 'mr-2.5': !sidebarMinimized || window.innerWidth < 768 }" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $moduleItem['icon_svg_path'] }}"></path></svg>
                    <span x-show="!sidebarMinimized || window.innerWidth < 768">{{ $moduleItem['title'] }}</span>
                </x-admin.nav-link>
            @endforeach
        @endif
    </nav>

    <!-- Sidebar Toggle Button -->
    <div class="mt-auto pt-4 border-t border-gray-200 dark:border-gray-700"
         :class="{'px-2': !sidebarMinimized || window.innerWidth < 768, 'px-0': sidebarMinimized && window.innerWidth >= 768 }">
        <button @click="sidebarMinimized = !sidebarMinimized" 
                class="w-full flex items-center text-sm font-medium rounded-md 
                       text-gray-600 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 
                       hover:text-gray-900 dark:hover:text-white transition-colors duration-150"
                :class="{'p-2': !sidebarMinimized || window.innerWidth < 768, 'p-2 justify-center': sidebarMinimized && window.innerWidth >= 768 }">
            <svg x-show="!sidebarMinimized || window.innerWidth < 768" class="h-5 w-5 shrink-0" :class="{'mr-2.5': !sidebarMinimized || window.innerWidth < 768}" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7"></path></svg>
            <svg x-show="sidebarMinimized && window.innerWidth >= 768" style="display:none;" class="h-5 w-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7"></path></svg>
            <span x-show="!sidebarMinimized || window.innerWidth < 768">Minimize</span>
            <span class="sr-only" x-show="sidebarMinimized && window.innerWidth >= 768" style="display:none;">Expand</span>
        </button>
    </div>

</aside>
