@extends('layouts.admin')

@section('title', 'Notifications')

@section('content')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-700 dark:text-gray-200">Notifications</h1>
        @if(Auth::user()->unreadNotifications()->count() > 0)
        <form action="{{ route('admin.notifications.markAllAsRead') }}" method="POST">
            @csrf
            <button type="submit" class="px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 text-sm">
                Mark All as Read
            </button>
        </form>
        @endif
    </div>

    @if (session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif

    @if($notifications->isEmpty())
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6 text-center">
            <p class="text-gray-500 dark:text-gray-400">You have no notifications.</p>
        </div>
    @else
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden">
            <ul class="divide-y divide-gray-200 dark:divide-gray-700">
                @foreach ($notifications as $notification)
                    <li class="p-4 hover:bg-gray-50 dark:hover:bg-gray-700 {{ $notification->read_at ? '' : 'bg-blue-50 dark:bg-blue-900/30 font-semibold' }}">
                        <div class="flex items-start space-x-3">
                            <div class="flex-shrink-0 pt-1">
                                @if(isset($notification->data['icon']))
                                    <i class="{{ $notification->data['icon'] }} text-blue-500 dark:text-blue-400 text-xl"></i>
                                @else
                                    <svg class="h-6 w-6 text-blue-500 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                @endif
                            </div>
                            <div class="flex-1 min-w-0">
                                <div class="text-sm">
                                    <p class="text-gray-800 dark:text-gray-100">
                                        {{ $notification->data['message'] ?? 'Notification' }}
                                    </p>
                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                        {{ $notification->created_at->diffForHumans() }}
                                    </p>
                                </div>
                            </div>
                            <div class="flex-shrink-0 self-center flex space-x-2">
                                @if(isset($notification->data['action_url']))
                                    <a href="{{ $notification->data['action_url'] }}" class="text-xs px-3 py-1 bg-gray-200 dark:bg-gray-600 text-gray-700 dark:text-gray-200 rounded-md hover:bg-gray-300 dark:hover:bg-gray-500">
                                        View
                                    </a>
                                @endif
                                @if(!$notification->read_at)
                                    <form action="{{ route('admin.notifications.markAsRead', $notification->id) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="text-xs px-3 py-1 bg-green-500 text-white rounded-md hover:bg-green-600">
                                            Mark as Read
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    </li>
                @endforeach
            </ul>
        </div>

        @if($notifications->hasPages())
            <div class="mt-6">
                {{ $notifications->links() }}
            </div>
        @endif
    @endif
</div>
@endsection