@extends('layouts.admin')

@section('title', 'View Newsletter: ' . $newsletter->subject)
@section('header_title', 'Preview Newsletter: ' . $newsletter->subject)

@section('content')
<div class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
    <div class="p-6 lg:p-8">
        <div class="mb-4">
            <a href="{{ route('admin.newsletters.index') }}" class="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300">&larr; Back to Newsletters</a>
        </div>
        <h3 class="text-2xl font-semibold text-gray-900 dark:text-gray-100 mb-2">{{ $newsletter->subject }}</h3>
        <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">Status: <span class="font-semibold">{{ ucfirst($newsletter->status) }}</span>
            @if($newsletter->sent_at) | Sent: {{ $newsletter->sent_at->format('M d, Y H:i') }} @endif
            @if($newsletter->recipients_count) | Recipients: {{ $newsletter->recipients_count }} @endif
        </p>
        <div class="prose dark:prose-invert max-w-none p-4 border border-gray-200 dark:border-gray-700 rounded-md">
            {!! $newsletter->content !!}
        </div>
    </div>
</div>
@endsection
