<div class="space-y-6">
    <div>
        <label for="subject" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Subject</label>
        <input type="text" name="subject" id="subject" value="{{ old('subject', $newsletter->subject ?? '') }}" required
               class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
        @error('subject') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="content" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Content (HTML)</label>
        <textarea name="content" id="content" rows="15"
                  class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm editor">{{ old('content', $newsletter->content ?? '') }}</textarea>
        @error('content') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
    </div>
</div>

<div class="mt-8 flex justify-end">
    <a href="{{ route('admin.newsletters.index') }}" class="bg-white dark:bg-gray-700 py-2 px-4 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 mr-3">
        Cancel
    </a>
    <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800">
        {{ isset($newsletter) && $newsletter->exists ? 'Update Newsletter' : 'Save Draft' }}
    </button>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.editor').forEach(editorEl => {
            ClassicEditor.create(editorEl, { /* CKEditor config */ })
            .catch(error => { console.error(error); });
        });
    });
</script>
@endpush
