@extends('layouts.admin')

@section('title', 'Install New Module')

@section('header_title', 'Install New Module')

@section('content')
    <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
        <div class="p-6 lg:p-8">
            <h1 class="text-2xl font-medium text-gray-900 dark:text-white mb-6">
                Upload Module ZIP File
            </h1>

            <form action="{{ route('admin.modules.upload') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="mb-4">
                    <label for="module_zip" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Module ZIP File</label>
                    <input type="file" name="module_zip" id="module_zip" accept=".zip" required
                           class="mt-1 block w-full text-sm text-gray-900 dark:text-gray-100 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer bg-gray-50 dark:bg-gray-700 focus:outline-none focus:border-indigo-500 focus:ring-indigo-500
                                  file:mr-4 file:py-2 file:px-4
                                  file:rounded-md file:border-0
                                  file:text-sm file:font-semibold
                                  file:bg-indigo-50 dark:file:bg-indigo-800 file:text-indigo-700 dark:file:text-indigo-200
                                  hover:file:bg-indigo-100 dark:hover:file:bg-indigo-700">
                    @error('module_zip')
                        <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="inline-flex items-center px-4 py-2 bg-gray-800 dark:bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-white dark:text-gray-800 uppercase tracking-widest hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                        Upload Module
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection