@extends('layouts.admin')

@section('title', 'Modules Management')

@section('header_title', 'Modules Management')

@section('content')
<div class="mb-6 flex justify-between items-center">
    <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">
        Installed Modules
    </h1>
    <a href="{{ route('admin.modules.install.form') }}"
       class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 dark:bg-blue-500 dark:hover:bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
        Install New Module
    </a>
</div>

@if (session('success'))
    <div class="mb-4 p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-200 dark:text-green-800" role="alert">
        {{ session('success') }}
    </div>
@endif
@if (session('error'))
    <div class="mb-4 p-4 text-sm text-red-700 bg-red-100 rounded-lg dark:bg-red-200 dark:text-red-800" role="alert">
        {{ session('error') }}
    </div>
@endif

<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        {{-- Check if $modules is a collection and then if it's empty, or if it's an array and empty --}}
        @if ((is_object($modules) && method_exists($modules, 'isEmpty') && $modules->isEmpty()) || (is_array($modules) && empty($modules)))
            <p class="text-center text-gray-500 dark:text-gray-400">No modules are currently installed.</p>
            <p class="text-center text-gray-500 dark:text-gray-400 mt-2">
                You can create a new module using the Artisan command: <code class="bg-gray-100 dark:bg-gray-700 p-1 rounded text-sm">php artisan module:make YourModuleName</code>
            </p>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Icon</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Name</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Description</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach ($modules as $module)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                    {{-- You can fetch an icon from module.json or use a default --}}
                                    @php
                                        $iconPath = $module->get('admin_menu.icon_path') ?? null;
                                        $iconClass = $module->get('admin_menu.icon_class') ?? 'M2.25 12.75V12A2.25 2.25 0 014.5 9.75h15A2.25 2.25 0 0121.75 12v.75m-8.69-6.44l-2.12-2.12a1.5 1.5 0 00-1.061-.44H4.5A2.25 2.25 0 002.25 6v12a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 18V9a2.25 2.25 0 00-2.25-2.25h-5.379a1.5 1.5 0 01-1.06-.44z'; // Default icon path
                                    @endphp
                                    @if($iconPath && file_exists(public_path($iconPath)))
                                        <img src="{{ asset($iconPath) }}" alt="{{ $module->getName() }} icon" class="h-6 w-6">
                                    @else
                                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="{{ $iconClass }}" /></svg>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-gray-100">{{ $module->getName() }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    @if ($module->isEnabled())
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100">Enabled</span>
                                    @else
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100">Disabled</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $module->get('description', 'N/A') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex space-x-2">
                                        @if ($module->isEnabled())
                                            <form action="{{ route('admin.modules.disable', ['moduleName' => $module->getName()]) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to disable the module \'{{ $module->getName() }}\'?');">
                                                @csrf
                                                <button type="submit" class="text-yellow-600 hover:text-yellow-900 dark:text-yellow-400 dark:hover:text-yellow-300">Disable</button>
                                            </form>
                                        @else
                                            <form action="{{ route('admin.modules.enable', ['moduleName' => $module->getName()]) }}" method="POST" class="inline-block">
                                                @csrf
                                                <button type="submit" class="text-green-600 hover:text-green-900 dark:text-green-400 dark:hover:text-green-300">Enable</button>
                                            </form>
                                        @endif

                                        {{-- Prevent uninstalling core or essential modules if needed --}}
                                        {{-- Adjust 'core', 'system' to your actual protected module names (lowercase) --}}
                                        @if (!in_array($module->getLowerName(), ['core', 'system', 'yourcoremodulename']))
                                            <form action="{{ route('admin.modules.uninstall', ['moduleName' => $module->getName()]) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to uninstall the module \'{{ $module->getName() }}\'? This action cannot be undone and may delete module data.');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300">Uninstall</button>
                                            </form>
                                        @else
                                            <span class="text-gray-400 dark:text-gray-500 italic text-xs" title="This module cannot be uninstalled.">Protected</span>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>
</div>
@endsection
