@props([
    'id',
    'name',
    'label',
    'value' => '1',
    'checked' => false,
    'helpText' => null,
])

<div>
    <label for="{{ $id }}" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">{{ $label }}</label>
    <label class="relative inline-flex items-center cursor-pointer mt-1">
        <input type="checkbox" id="{{ $id }}" name="{{ $name }}" class="sr-only peer" value="{{ $value }}" {{ $checked ? 'checked' : '' }} {{ $attributes }}>
        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
        {{-- Optional: Text next to toggle if needed, passed via slot or another prop --}}
        {{-- <span class="ml-3 text-sm font-medium text-gray-900 dark:text-gray-300">Enabled</span> --}}
    </label>
    @if($helpText)
        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ $helpText }}</p>
    @endif
    @error($name) <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
</div>
