@extends('layouts.admin')

@section('title', 'Feature Credit Costs')
@section('header_title', 'Manage Feature Credit Costs')

@section('content')
    <div class="mb-6 flex justify-between items-center">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">
            Feature Credit Costs
        </h1>
        <a href="{{ route('admin.feature-credit-costs.create') }}"
           class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition ease-in-out duration-150">
            Define New Cost
        </a>
    </div>

    @include('admin.partials.alerts')

    <div class="mb-4">
        <form action="{{ route('admin.feature-credit-costs.index') }}" method="GET">
            <input type="text" name="search" value="{{ request('search') }}" placeholder="Search feature key..."
                   class="form-input rounded-md shadow-sm dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600">
            <button type="submit" class="ml-2 px-4 py-2 bg-gray-200 dark:bg-gray-600 text-gray-700 dark:text-gray-200 rounded-md hover:bg-gray-300 dark:hover:bg-gray-500">Search</button>
        </form>
    </div>

    <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
        <div class="p-6 lg:p-8">
            @if($featureCosts->isEmpty())
                <p class="text-center text-gray-500 dark:text-gray-400">No feature credit costs defined yet. <a href="{{ route('admin.feature-credit-costs.create') }}" class="text-blue-500 hover:underline">Define one now</a>.</p>
            @else
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-700">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Feature Key</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Credit Cost</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            @foreach ($featureCosts as $cost)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-gray-100 font-mono">{{ $cost->feature_key }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">{{ $cost->credit_cost }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <a href="{{ route('admin.feature-credit-costs.edit', $cost) }}" class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-200">Edit</a>
                                        <form action="{{ route('admin.feature-credit-costs.destroy', $cost) }}" method="POST" class="inline-block ml-2" onsubmit="return confirm('Are you sure you want to delete this cost definition?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 dark:text-red-400 hover:text-red-900 dark:hover:text-red-200">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-4">
                    {{ $featureCosts->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection