@include('admin.partials.alerts') {{-- For displaying validation errors --}}

<form action="{{ $action }}" method="POST">
    @csrf
    @if($method === 'PUT')
        @method('PUT')
    @endif

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Feature Key -->
        <div>
            <label for="feature_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Feature Key</label>
            @if($featureCreditCost->exists)
                <input type="text" id="feature_key_display" value="{{ $featureCreditCost->feature_key }}" readonly
                       class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-400 rounded-md shadow-sm cursor-not-allowed">
                <input type="hidden" name="feature_key" value="{{ $featureCreditCost->feature_key }}">
            @else
                <select name="feature_key" id="feature_key" required
                        class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    <option value="">Select a feature...</option>
                    @foreach($creatableFeatureKeys as $key => $displayName)
                        <option value="{{ $key }}" {{ old('feature_key') == $key ? 'selected' : '' }}>{{ $displayName }}</option>
                    @endforeach
                </select>
            @endif
            @error('feature_key') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- Credit Cost -->
        <div>
            <label for="credit_cost" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Credit Cost</label>
            <input type="number" name="credit_cost" id="credit_cost" value="{{ old('credit_cost', $featureCreditCost->credit_cost ?? 0) }}" min="0" required
                   class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
            @error('credit_cost') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>
    </div>

    <div class="mt-6 flex justify-end">
        <a href="{{ route('admin.feature-credit-costs.index') }}" class="inline-flex items-center px-4 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-500 rounded-md font-semibold text-xs text-gray-700 dark:text-gray-300 uppercase tracking-widest shadow-sm hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 disabled:opacity-25 transition ease-in-out duration-150">Cancel</a>
        <button type="submit" class="ml-3 inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition ease-in-out duration-150">{{ $featureCreditCost->exists ? 'Update Cost' : 'Create Cost' }}</button>
    </div>
</form>