@extends('layouts.admin')

@section('title', 'Admin Dashboard')
@section('header_title', 'Dashboard Overview')

@section('content')
    <div class="-mx-4 sm:-mx-6 lg:-mx-8"> {{-- Negative margins to counteract layout padding --}}
        <div class="px-4 sm:px-6 lg:px-8"> {{-- Re-apply padding for content blocks if needed, or manage padding within each block --}}
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 hover:shadow-2xl transition-shadow duration-300">
                    <div class="flex items-center">
                        <div class="p-4 rounded-full bg-blue-100 dark:bg-blue-500 dark:bg-opacity-25 text-blue-500 dark:text-blue-300">
                            <x-heroicon-o-users class="h-8 w-8" />
                        </div>
                        <div class="ml-4">
                            <p class="text-2xl font-bold text-gray-800 dark:text-gray-100">{{ $stats['total_users'] ?? 'N/A' }}</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Total Users</p>
                        </div>
                    </div>
                </div>
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 hover:shadow-2xl transition-shadow duration-300">
                    <div class="flex items-center">
                        <div class="p-4 rounded-full bg-green-100 dark:bg-green-500 dark:bg-opacity-25 text-green-500 dark:text-green-300">
                            <x-heroicon-o-user-group class="h-8 w-8" />
                        </div>
                        <div class="ml-4">
                            <p class="text-2xl font-bold text-gray-800 dark:text-gray-100">{{ $stats['admin_users'] ?? 'N/A' }}</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Admin Users</p>
                        </div>
                    </div>
                </div>
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 hover:shadow-2xl transition-shadow duration-300">
                    <div class="flex items-center">
                        <div class="p-4 rounded-full bg-yellow-100 dark:bg-yellow-500 dark:bg-opacity-25 text-yellow-500 dark:text-yellow-300">
                             <x-heroicon-o-check-circle class="h-8 w-8" />
                        </div>
                        <div class="ml-4">
                            <p class="text-2xl font-bold text-gray-800 dark:text-gray-100">{{ $stats['active_modules'] ?? 'N/A' }}</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Active Modules</p>
                        </div>
                    </div>
                </div>
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6 hover:shadow-2xl transition-shadow duration-300">
                    <div class="flex items-center">
                        <div class="p-4 rounded-full bg-indigo-100 dark:bg-indigo-500 dark:bg-opacity-25 text-indigo-500 dark:text-indigo-300">
                            <x-heroicon-o-squares-plus class="h-8 w-8" />
                        </div>
                        <div class="ml-4">
                            <p class="text-2xl font-bold text-gray-800 dark:text-gray-100">{{ $stats['total_modules'] ?? 'N/A' }}</p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Total Modules</p>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Google Analytics Summary - Conditionally Displayed --}}
            @if (Module::has('LandingPage') && Module::isEnabled('LandingPage'))
                @if (isset($landingPageGaEnabled) && $landingPageGaEnabled && isset($gaStats))
                    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
                        <div class="lg:col-span-3 bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6">
                            <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-2 text-blue-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M16 8v8m-4-5v5m-4-2v2m-2 4h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                </svg>
                                Website Analytics (Last 7 Days - via LandingPage Module)
                            </h3>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                {{-- Users Card --}}
                                <div class="bg-slate-50 dark:bg-slate-700/50 p-5 rounded-lg">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 bg-teal-500 dark:bg-teal-700 rounded-md p-3">
                                            <x-heroicon-o-users class="h-6 w-6 text-white" />
                                        </div>
                                        <div class="ml-4">
                                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">Total Users</dt>
                                            <dd class="text-2xl font-semibold text-gray-900 dark:text-white">{{ $gaStats['users'] ?? 'N/A' }}</dd>
                                        </div>
                                    </div>
                                </div>
                                {{-- Page Views Card --}}
                                <div class="bg-slate-50 dark:bg-slate-700/50 p-5 rounded-lg">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 bg-pink-500 dark:bg-pink-700 rounded-md p-3">
                                            <x-heroicon-o-eye class="h-6 w-6 text-white" />
                                        </div>
                                        <div class="ml-4">
                                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">Page Views</dt>
                                            <dd class="text-2xl font-semibold text-gray-900 dark:text-white">{{ $gaStats['pageViews'] ?? 'N/A' }}</dd>
                                        </div>
                                    </div>
                                </div>
                                {{-- Sessions Card --}}
                                <div class="bg-slate-50 dark:bg-slate-700/50 p-5 rounded-lg">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 bg-amber-500 dark:bg-amber-700 rounded-md p-3">
                                            <x-heroicon-o-clock class="h-6 w-6 text-white" /> {{-- Using clock as a proxy for sessions --}}
                                        </div>
                                        <div class="ml-4">
                                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">Sessions</dt>
                                            <dd class="text-2xl font-semibold text-gray-900 dark:text-white">{{ $gaStats['sessions'] ?? 'N/A' }}</dd>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif (setting('google_analytics_enable_tracking', false) && !setting('google_analytics_property_id'))
                    <div class="mb-6 p-4 bg-yellow-100 dark:bg-yellow-700 border-l-4 border-yellow-400 text-yellow-700 dark:text-yellow-200 rounded-md" role="alert">
                        Landing Page Google Analytics tracking is enabled, but the <strong>Property ID</strong> is not set. Statistics cannot be displayed. Please configure it in the Landing Page module's <a href="{{ Route::has('admin.landingpage.theme.settings.edit') ? route('admin.landingpage.theme.settings.edit') : '#' }}" class="font-semibold underline">Theme Settings</a>.
                    </div>
                @endif
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
                <div class="lg:col-span-2 bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6">
                    <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4">User Registrations (Last 7 Days)</h3>
                    <div class="h-72">
                        <canvas id="userRegistrationsChart"></canvas>
                    </div>
                </div>

                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6">
                    <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4">System Information</h3>
                    <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-3">
                        <li class="flex justify-between"><span>PHP Version:</span> <span class="font-medium text-gray-700 dark:text-gray-100">{{ PHP_VERSION }}</span></li>
                        <li class="flex justify-between"><span>Laravel Version:</span> <span class="font-medium text-gray-700 dark:text-gray-100">{{ app()->version() }}</span></li>
                        <li class="flex justify-between"><span>Debug Mode:</span>
                            <span class="px-2 py-0.5 inline-flex text-xs leading-5 font-semibold rounded-full {{ config('app.debug') ? 'bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100' : 'bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100' }}">
                                {{ config('app.debug') ? 'Enabled' : 'Disabled' }}
                            </span>
                        </li>
                        <li class="flex justify-between"><span>App Environment:</span> <span class="font-medium text-gray-700 dark:text-gray-100">{{ config('app.env') }}</span></li>
                        <li class="flex justify-between"><span>Cache Driver:</span> <span class="font-medium text-gray-700 dark:text-gray-100">{{ config('cache.default') }}</span></li>
                        <li class="flex justify-between"><span>Queue Driver:</span> <span class="font-medium text-gray-700 dark:text-gray-100">{{ config('queue.default') }}</span></li>
                        {{-- Add more system info as needed --}}
                    </ul>
                </div>
            </div>

            <div class="grid grid-cols-1 gap-6">
                <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl p-6">
                    <h3 class="text-xl font-semibold text-gray-700 dark:text-gray-200 mb-4">Recent Activity</h3>
                    @if(empty($recentActivities))
                        <p class="text-gray-500 dark:text-gray-400 text-center py-4">No recent activity to display.</p>
                    @else
                        <ul class="divide-y divide-gray-200 dark:divide-gray-700">
                            @foreach($recentActivities as $activity)
                                <li class="py-4 flex items-center space-x-3">
                                    {{-- Example: User registration icon --}}
                                    <div class="p-2 bg-blue-100 dark:bg-blue-500 dark:bg-opacity-25 rounded-full">
                                        <x-heroicon-o-user-plus class="h-5 w-5 text-blue-500 dark:text-blue-300"/>
                                    </div>
                                    <div>
                                        <p class="text-sm text-gray-700 dark:text-gray-300">{{ $activity->description ?? 'Activity description missing' }}</p>
                                        <p class="text-xs text-gray-400 dark:text-gray-500">{{ $activity->created_at->diffForHumans() }}</p>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const userRegistrationData = @json($userRegistrationChartData ?? ['labels' => [], 'data' => []]);
        const chartCanvas = document.getElementById('userRegistrationsChart');

        if (chartCanvas) { // Check if canvas element exists
            if (userRegistrationData.labels && userRegistrationData.labels.length > 0) { // Check if there's data
                const ctx = chartCanvas.getContext('2d');
                new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: userRegistrationData.labels,
                        datasets: [{
                            label: 'New Users',
                            data: userRegistrationData.data,
                            borderColor: 'rgba(59, 130, 246, 0.8)', // blue-500
                            backgroundColor: 'rgba(59, 130, 246, 0.2)',
                            tension: 0.3,
                            fill: true,
                            pointBackgroundColor: 'rgba(59, 130, 246, 1)',
                            pointBorderColor: '#fff',
                            pointHoverRadius: 6,
                            pointHoverBackgroundColor: 'rgba(59, 130, 246, 1)',
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    color: document.documentElement.classList.contains('dark') ? '#9ca3af' : '#6b7280', // gray-400 or gray-500
                                    stepSize: 1 // Ensure whole numbers for user counts
                                },
                                grid: {
                                    color: document.documentElement.classList.contains('dark') ? 'rgba(255,255,255,0.1)' : 'rgba(0,0,0,0.1)',
                                }
                            },
                            x: {
                                ticks: {
                                    color: document.documentElement.classList.contains('dark') ? '#9ca3af' : '#6b7280',
                                },
                                grid: {
                                    display: false,
                                }
                            }
                        },
                        plugins: {
                            legend: {
                                display: false,
                            },
                            tooltip: {
                                backgroundColor: document.documentElement.classList.contains('dark') ? '#374151' : '#fff', // gray-700 or white
                                titleColor: document.documentElement.classList.contains('dark') ? '#e5e7eb' : '#1f2937', // gray-200 or gray-800
                                bodyColor: document.documentElement.classList.contains('dark') ? '#d1d5db' : '#374151', // gray-300 or gray-700
                                borderColor: document.documentElement.classList.contains('dark') ? '#4b5563' : '#e5e7eb', // gray-600 or gray-200
                                borderWidth: 1,
                            }
                        }
                    },
                });
            } else { // No data, display message
                const chartContainer = chartCanvas.parentElement;
                if (chartContainer) {
                    chartContainer.innerHTML = '<p class="text-center text-gray-500 dark:text-gray-400 py-10">No user registration data to display for the last 7 days.</p>';
                    chartContainer.style.height = 'auto'; // Adjust height
                }
            }
        }
    });
</script>
@endpush
