@extends('layouts.frontend')

@section('title', 'Setup Application')
@section('header_title', 'Application Setup')

@section('content')
{{-- The layout 'layouts.frontend' now handles the centering and card styling --}}

<div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.7); z-index: 9999; flex-direction: column; justify-content: center; align-items: center; padding: 1rem;">
    <div class="bg-white dark:bg-gray-800 p-8 rounded-lg shadow-xl text-center">
        <svg class="animate-spin h-12 w-12 text-purple-600 mx-auto" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
        </svg>
        <h3 class="text-xl font-semibold text-gray-800 dark:text-gray-200 mt-4">Installation in Progress</h3>
        <p class="text-gray-600 dark:text-gray-400 mt-2">Please wait, this may take a few moments...</p>
        <p class="text-sm text-gray-500 dark:text-gray-500 mt-1">Do not close this window or navigate away.</p>
    </div>
</div>


{{-- This div is the direct content within the layout's <main> card --}}
    <div>
        <h3 class="text-2xl font-bold text-center text-gray-800 dark:text-gray-200">Step 2: Setup Database & Admin User</h3>
        <p class="text-sm text-center text-gray-600 dark:text-gray-400 mt-1 mb-6">
            Your license for domain <strong>{{ session('activation_data.activated_domain', $domain ?? 'your domain') }}</strong> has been pre-validated.
        </p>

        {{-- Flash messages are now included from the layout --}}
        {{-- @include('layouts.partials.flash-messages') is in layouts.frontend --}}
        {{-- It will handle displaying errors/info if the page reloads after a failed submission attempt --}}

        <form id="setupForm" method="POST" action="{{ route('install.setup.process') }}" class="mt-6 space-y-6">
            @csrf

            <fieldset class="border p-4 rounded-md dark:border-gray-700">
                <legend class="text-lg font-medium text-gray-900 dark:text-gray-100 px-2">Database Configuration</legend>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-2">
                    <div>
                        <label for="db_host" class="block text-sm font-medium text-gray-700 dark:text-gray-300">DB Host <span class="text-red-500">*</span></label>
                        <input type="text" name="db_host" id="db_host" value="{{ old('db_host', '127.0.0.1') }}" required class="input-field">
                        @error('db_host') <p class="error-message">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="db_port" class="block text-sm font-medium text-gray-700 dark:text-gray-300">DB Port <span class="text-red-500">*</span></label>
                        <input type="number" name="db_port" id="db_port" value="{{ old('db_port', 3306) }}" required class="input-field">
                        @error('db_port') <p class="error-message">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="db_database" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Database Name <span class="text-red-500">*</span></label>
                        <input type="text" name="db_database" id="db_database" value="{{ old('db_database') }}" required class="input-field">
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">The name of the database you have already created for this application.</p>
                        @error('db_database') <p class="error-message">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="db_username" class="block text-sm font-medium text-gray-700 dark:text-gray-300">DB Username <span class="text-red-500">*</span></label>
                        <input type="text" name="db_username" id="db_username" value="{{ old('db_username') }}" required class="input-field">
                        @error('db_username') <p class="error-message">{{ $message }}</p> @enderror
                    </div>
                    <div class="md:col-span-2">
                        <label for="db_password" class="block text-sm font-medium text-gray-700 dark:text-gray-300">DB Password</label>
                        <input type="password" name="db_password" id="db_password" class="input-field">
                        @error('db_password') <p class="error-message">{{ $message }}</p> @enderror
                    </div>
                </div>
            </fieldset>

            <fieldset class="border p-4 rounded-md dark:border-gray-700 mt-6">
                <legend class="text-lg font-medium text-gray-900 dark:text-gray-100 px-2">Admin User Creation</legend>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-2">
                    <div>
                        <label for="admin_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Admin Name <span class="text-red-500">*</span></label>
                        <input type="text" name="admin_name" id="admin_name" value="{{ old('admin_name') }}" required class="input-field">
                        @error('admin_name') <p class="error-message">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="admin_email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Admin Email <span class="text-red-500">*</span></label>
                        <input type="email" name="admin_email" id="admin_email" value="{{ old('admin_email') }}" required class="input-field">
                        @error('admin_email') <p class="error-message">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="admin_password" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Admin Password <span class="text-red-500">*</span></label>
                        <input type="password" name="admin_password" id="admin_password" required class="input-field">
                        @error('admin_password') <p class="error-message">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label for="admin_password_confirmation" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Confirm Password <span class="text-red-500">*</span></label>
                        <input type="password" name="admin_password_confirmation" id="admin_password_confirmation" required class="input-field">
                    </div>
                </div>
            </fieldset>

            <div class="mt-8">
                <button id="submitButton" type="submit" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-md shadow-sm text-base font-medium text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                    Complete Installation
                </button>
            </div>
        </form>
    </div>
<style>
    .input-field { margin-top: 0.25rem; display: block; width: 100%; box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05); font-size: 0.875rem; line-height: 1.25rem; border-color: #D1D5DB; border-radius: 0.375rem; }
    .dark .input-field { border-color: #4B5563; background-color: #374151; color: #F3F4F6; }
    .input-field:focus { ring-color: #A78BFA; border-color: #A78BFA; }
    .error-message { margin-top: 0.25rem; font-size: 0.875rem; line-height: 1.25rem; color: #EF4444; }
</style>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const setupForm = document.getElementById('setupForm');
        const submitButton = document.getElementById('submitButton');
        const loadingOverlay = document.getElementById('loadingOverlay');

        if (setupForm && submitButton && loadingOverlay) {
            setupForm.addEventListener('submit', function () {
                loadingOverlay.style.display = 'flex'; // Show the overlay
                submitButton.disabled = true;
                submitButton.innerHTML = '<svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Installing...';
            });
        }
    });
</script>
@endpush
@endsection