<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting; // Ensure your Setting model is correctly namespaced
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;

class SettingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // General Settings
            ['name' => 'Site Name', 'key' => 'site_name', 'value' => 'Digital Vocano', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Site Logo Path (e.g., settings_uploads/logo.png)', 'key' => 'site_logo', 'value' => null, 'type' => 'file', 'group' => 'General'],
            ['name' => 'Site Favicon Path (e.g., settings_uploads/favicon.ico)', 'key' => 'site_favicon', 'value' => null, 'type' => 'file', 'group' => 'General'],
            ['name' => 'Contact Email', 'key' => 'contact_email', 'value' => 'contact@example.com', 'type' => 'text', 'group' => 'General'], // Generic default
            ['name' => 'Admin Email', 'key' => 'admin_email', 'value' => 'admin@example.com', 'type' => 'text', 'group' => 'General'], // Generic default
            ['name' => 'Site Tagline', 'key' => 'site_tagline', 'value' => 'Innovative Solutions for a Digital World.', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Top Bar Tagline', 'key' => 'top_bar_tagline', 'value' => 'Your Expert Digital Partner', 'type' => 'text', 'group' => 'General'],
            ['name' => 'WhatsApp Number', 'key' => 'whatsapp_number', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'WhatsApp Default Message', 'key' => 'whatsapp_default_message', 'value' => 'Hello! I have a question.', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Enable Google Analytics Tracking', 'key' => 'google_analytics_enable_tracking', 'value' => '0', 'type' => 'checkbox', 'group' => 'General'], // Changed from 'text' to 'checkbox' for consistency
            ['name' => 'Google Analytics Tracking ID', 'key' => 'google_analytics_tracking_id', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'Google Analytics Property ID', 'key' => 'google_analytics_property_id', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'Google Analytics Credentials Path', 'key' => 'google_analytics_credentials_path', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'Facebook URL', 'key' => 'social_facebook_url', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'LinkedIn URL', 'key' => 'social_linkedin_url', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'YouTube URL', 'key' => 'social_youtube_url', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'Twitter (X) URL', 'key' => 'social_twitter_url', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'TikTok URL', 'key' => 'social_tiktok_url', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'Instagram URL', 'key' => 'social_instagram_url', 'value' => null, 'type' => 'text', 'group' => 'General'],
            ['name' => 'Top Bar Bg Light', 'key' => 'top_bar_bg_light', 'value' => '#000000', 'type' => 'text', 'group' => 'General'], // Assuming text is color picker
            ['name' => 'Top Bar Text Light', 'key' => 'top_bar_text_light', 'value' => '#ffffff', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Top Bar Bg Dark', 'key' => 'top_bar_bg_dark', 'value' => '#111827', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Top Bar Text Dark', 'key' => 'top_bar_text_dark', 'value' => '#d1d5db', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Header Bg Light', 'key' => 'header_bg_light', 'value' => '#d22dcd', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Header Text Light', 'key' => 'header_text_light', 'value' => '#374151', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Header Bg Dark', 'key' => 'header_bg_dark', 'value' => '#1f2937', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Header Text Dark', 'key' => 'header_text_dark', 'value' => '#d1d5db', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Accent Color Light', 'key' => 'accent_color_light', 'value' => '#7c3aed', 'type' => 'text', 'group' => 'General'],
            ['name' => 'Accent Color Dark', 'key' => 'accent_color_dark', 'value' => '#a78bfa', 'type' => 'text', 'group' => 'General'],

            // Social Login (placeholders or disabled by default)
            ['name' => 'Enable Google Login', 'key' => 'google_login_enabled', 'value' => '0', 'type' => 'checkbox', 'group' => 'Social Login'],
            ['name' => 'Google Client ID', 'key' => 'google_client_id', 'value' => null, 'type' => 'text', 'group' => 'Social Login'],
            ['name' => 'Google Client Secret', 'key' => 'google_client_secret', 'value' => null, 'type' => 'password', 'group' => 'Social Login'],
            ['name' => 'Enable Facebook Login', 'key' => 'facebook_login_enabled', 'value' => '0', 'type' => 'checkbox', 'group' => 'Social Login'],
            ['name' => 'Facebook App ID', 'key' => 'facebook_app_id', 'value' => null, 'type' => 'text', 'group' => 'Social Login'],
            ['name' => 'Facebook App Secret', 'key' => 'facebook_app_secret', 'value' => null, 'type' => 'password', 'group' => 'Social Login'],

            // Mail Settings (sensible defaults, to be configured by admin)
            ['name' => 'Mail Mailer', 'key' => 'mail_mailer', 'value' => 'smtp', 'type' => 'text', 'group' => 'Mail Settings'],
            ['name' => 'Mail Host', 'key' => 'mail_host', 'value' => 'localhost', 'type' => 'text', 'group' => 'Mail Settings'],
            ['name' => 'Mail Port', 'key' => 'mail_port', 'value' => '1025', 'type' => 'text', 'group' => 'Mail Settings'],
            ['name' => 'Mail Username', 'key' => 'mail_username', 'value' => null, 'type' => 'text', 'group' => 'Mail Settings'],
            ['name' => 'Mail Password', 'key' => 'mail_password', 'value' => null, 'type' => 'password', 'group' => 'Mail Settings'],
            ['name' => 'Mail Encryption', 'key' => 'mail_encryption', 'value' => 'tls', 'type' => 'text', 'group' => 'Mail Settings'],
            ['name' => 'Mail From Address', 'key' => 'mail_from_address', 'value' => 'noreply@example.com', 'type' => 'text', 'group' => 'Mail Settings'], // Generic default
            ['name' => 'Mail From Name', 'key' => 'mail_from_name', 'value' => 'Digital Vocano', 'type' => 'text', 'group' => 'Mail Settings'],

            // Landing Page
            ['name' => 'Enable Landing Page', 'key' => 'landing_page_enabled', 'value' => '1', 'type' => 'checkbox', 'group' => 'Landing Page'],
            ['name' => 'Landing Page Active Theme', 'key' => 'landingpage_active_theme', 'value' => 'ai_website_maker', 'type' => 'select', 'group' => 'Landing Page'],
            ['name' => 'Homepage Slug', 'key' => 'landingpage_homepage_slug', 'value' => 'home', 'type' => 'text', 'group' => 'Landing Page'],

            // Landing Page SEO
            ['name' => 'SEO Title Suffix (Appended after page title)', 'key' => 'landingpage_seo_title_suffix', 'value' => 'Digital Vocano', 'type' => 'text', 'group' => 'Landing Page SEO'],
            ['name' => 'Global Meta Description (Fallback)', 'key' => 'landingpage_global_meta_description', 'value' => 'Welcome to Digital Vocano, your partner for innovative digital solutions and cutting-edge web development.', 'type' => 'textarea', 'group' => 'Landing Page SEO'],
            ['name' => 'Global Meta Keywords (Comma-separated)', 'key' => 'landingpage_global_meta_keywords', 'value' => 'digital vocano, web development, software, portfolio, laravel modules', 'type' => 'text', 'group' => 'Landing Page SEO'],

            // Features
            ['name' => 'Allow User Team Access', 'key' => 'allow_user_team_access', 'value' => '1', 'type' => 'checkbox', 'group' => 'Features'],

            // Subscriptions
            ['name' => 'Enable Subscription System', 'key' => 'subscriptions_enabled', 'value' => '0', 'type' => 'checkbox', 'group' => 'Subscriptions'], // Default to off for fresh install

            // User Registration
            ['name' => 'Enable Role Selection on Registration', 'key' => 'enable_role_selection_on_registration', 'value' => '0', 'type' => 'checkbox', 'group' => 'User Registration'],

            // Security
            ['name' => 'Enable Magic Login (Admin as User)', 'key' => 'magic_login_enabled', 'value' => '1', 'type' => 'checkbox', 'group' => 'Security'],

            // Zimflow Gateway
            ['name' => 'Zimflow Api Endpoint', 'key' => 'zimflow_api_endpoint', 'value' => 'https://zimflow.co.zw/', 'type' => 'text', 'group' => 'Zimflow Gateway'],
            ['name' => 'Zimflow Api Token', 'key' => 'zimflow_api_token', 'value' => null, 'type' => 'text', 'group' => 'Zimflow Gateway'], // Sensitive, set to null
            ['name' => 'Zimflow Notifications Enabled', 'key' => 'zimflow_notifications_enabled', 'value' => '1', 'type' => 'checkbox', 'group' => 'Zimflow Gateway'],

            // Integrations
            ['name' => 'TinyMCE API Key', 'key' => 'tinymce_api_key', 'value' => null, 'type' => 'text', 'group' => 'Integrations'], // Set to null or a free key if available

            // AI Model Providers
            ['name' => 'Enable OpenAI Models', 'key' => 'enable_openai_models', 'value' => '0', 'type' => 'checkbox', 'group' => 'AI Model Providers'], // Changed from boolean to checkbox string '0'/'1'
            ['name' => 'OpenAI API Key', 'key' => 'openai_api_key', 'value' => null, 'type' => 'password', 'group' => 'AI Model Providers'],
            ['name' => 'Enable Anthropic Models', 'key' => 'enable_anthropic_models', 'value' => '0', 'type' => 'checkbox', 'group' => 'AI Model Providers'], // Changed from boolean to checkbox string '0'/'1'
            ['name' => 'Anthropic API Key', 'key' => 'anthropic_api_key', 'value' => null, 'type' => 'password', 'group' => 'AI Model Providers'],

            // Deployment Settings
            ['name' => 'Default Deployment Path cPanel', 'key' => 'default_deployment_path_cpanel', 'value' => 'public_html', 'type' => 'text', 'group' => 'Deployment Settings'],
        ];

        foreach ($settings as $settingData) {
            // If 'name' is empty (as in IDs 59-63 from your dump), generate one from the key
            $name = $settingData['name'];
            if (empty($name) && !empty($settingData['key'])) {
                $name = Str::title(str_replace('_', ' ', $settingData['key']));
            }

            // Ensure 'type' is consistent (e.g., 'checkbox' for boolean-like values)
            $type = $settingData['type'];
            if ($type === 'boolean' && ($settingData['value'] === '1' || $settingData['value'] === '0')) {
                $type = 'checkbox';
            }

            Setting::updateOrCreate(
                ['key' => $settingData['key']], // Unique key to find or create by
                [
                    'name' => $name,
                    'value' => $settingData['value'],
                    'type' => $type,
                    'group' => $settingData['group'],
                ]
            );
        }

        // Clear settings cache after seeding
        // This uses a common cache key, adjust if your Setting model has a specific method
        Cache::forget(config('settings.cache_key', 'app_settings'));
        // If your Setting model has a static method to clear its specific cache:
        // if (method_exists(Setting::class, 'clearCache')) {
        //     Setting::clearCache();
        // }

        $this->command->info('Default application settings seeded successfully.');
    }
}