<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
// use Illuminate\Database\Eloquent\Model; // Not strictly needed here unless you unguard globally

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // Example: Call your main application seeders first if you have them
        // $this->call(UserSeeder::class);
        $this->call([
            SettingsTableSeeder::class, // Corrected to use the actual seeder class name
            // Add other core seeders here if necessary, like RoleAndPermissionSeeder
        ]);

        // Call seeders from your modules
        // Example for another module:
        // if (class_exists(\Modules\DigitalVocano\Database\Seeders\DigitalVocanoDatabaseSeeder::class)) {
        //     $this->call(\Modules\DigitalVocano\Database\Seeders\DigitalVocanoDatabaseSeeder::class);
        // }

        if (class_exists(\Modules\LandingPage\Database\Seeders\LandingPageDatabaseSeeder::class)) {
            $this->call(\Modules\LandingPage\Database\Seeders\LandingPageDatabaseSeeder::class);
        }

        // Add calls to other module seeders here as you create them
        // e.g., $this->call(\Modules\Jobs\Database\Seeders\JobsDatabaseSeeder::class);

        $this->command->info('All specified database seeders completed successfully.');
    }
}
