<?php

use Laravel\Jetstream\Features;
use Laravel\Jetstream\Http\Middleware\AuthenticateSession;


// --- The configuration file must return a single array ---
return [

    /*
    |--------------------------------------------------------------------------
    | Jetstream Stack
    |--------------------------------------------------------------------------
    */
    'stack' => 'livewire', // Make sure this and other top-level keys are here

    /*
    |--------------------------------------------------------------------------
    | Jetstream Route Middleware
    |--------------------------------------------------------------------------
    */
    'middleware' => ['web'],

    'auth_session' => AuthenticateSession::class,

    /*
    |--------------------------------------------------------------------------
    | Jetstream Guard
    |--------------------------------------------------------------------------
    */
    'guard' => 'web', // Change this to 'web' for session-based web authentication

    /*
    |--------------------------------------------------------------------------
    | Features
    |--------------------------------------------------------------------------
    */
    'features' => [
        Features::teams(['invitations' => true]), // Explicitly enable teams with invitations
        // Other standard Jetstream features
        Features::profilePhotos(),
        // Features::api(),
        Features::termsAndPrivacyPolicy(),
        // Features::accountDeletion(),
    ],

    /*
    |--------------------------------------------------------------------------
    | Profile Photo Disk
    |--------------------------------------------------------------------------
    */
    'profile_photo_disk' => 'public',

];
