<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;
use App\Models\Setting;

class SocialiteConfigServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            return;
        }

        try {
            if (Setting::getValue('google_login_enabled', '0') === '1') {
                $googleClientId = Setting::getValue('google_client_id', config('services.google.client_id'));
                $googleClientSecret = Setting::getValue('google_client_secret', config('services.google.client_secret'));

                if ($googleClientId && $googleClientSecret) {
                    Config::set('services.google.client_id', $googleClientId);
                    Config::set('services.google.client_secret', $googleClientSecret);
                }
            }

            if (Setting::getValue('facebook_login_enabled', '0') === '1') {
                $facebookClientId = Setting::getValue('facebook_client_id', config('services.facebook.client_id'));
                $facebookClientSecret = Setting::getValue('facebook_client_secret', config('services.facebook.client_secret'));

                if ($facebookClientId && $facebookClientSecret) {
                    Config::set('services.facebook.client_id', $facebookClientId);
                    Config::set('services.facebook.client_secret', $facebookClientSecret);
                }
            }
        } catch (\Exception $e) {
        }
    }
}