<?php

namespace App\Providers;

use App\Actions\Fortify\CreateNewUser;
use App\Actions\Fortify\ResetUserPassword;
use App\Actions\Fortify\UpdateUserPassword;
use App\Actions\Fortify\UpdateUserProfileInformation;
use App\Models\User; // Make sure User model is imported
use Illuminate\Http\Request; // Import Request
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\ServiceProvider;
use Laravel\Fortify\Fortify;
use App\Providers\RouteServiceProvider; // Import RouteServiceProvider

class FortifyServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Fortify::createUsersUsing(CreateNewUser::class);

        Fortify::registerView(function () {
            return view('auth.register');
        });

        Fortify::loginView(function () {
            return view('auth.login');
        });

        // Customizing authentication to fetch user for role check
        // Fortify::authenticateThrough(function (Request $request) {
        //     // Ensure we are attempting to authenticate with the 'email' field
        //     // as defined in config/fortify.php ('username' => 'email')
        //     $credentials = $request->only(Fortify::username(), 'password');

        //     $user = User::where(Fortify::username(), $credentials[Fortify::username()])->first();

        //     if ($user && Hash::check($credentials['password'], $user->password)) {
        //         return $user; // Return the user object on success
        //     }
        //     return null; // Return null or false on failure
        // });


        Fortify::requestPasswordResetLinkView(function () {
            return view('auth.forgot-password');
        });

        Fortify::resetPasswordView(function (Request $request) {
            return view('auth.reset-password', ['request' => $request]);
        });

        Fortify::verifyEmailView(function () {
            return view('auth.verify-email');
        });

        Fortify::twoFactorChallengeView(function () {
            return view('auth.two-factor-challenge');
        });

        // Add custom redirect after login
        Fortify::redirects('login', function (Request $request) {
            $user = $request->user(); // Fortify ensures $request->user() is populated on successful login
            if ($user && $user->isAdmin()) { // Use the new isAdmin() method
                return route('admin.dashboard');
            }
            return RouteServiceProvider::HOME; // Default to user dashboard
        });

        Fortify::redirects('register', RouteServiceProvider::HOME);

        Fortify::redirects('password.update', RouteServiceProvider::HOME);

        Fortify::redirects('verification.notice', RouteServiceProvider::HOME); 
    }
}
