<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Log;  // For logging
use Modules\WebPilotAI\Models\Website; // Import the Website model
use Modules\WebPilotAI\Policies\WebsitePolicy; 
use App\Models\User; // Assuming your User model is here

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // Example:
        // \App\Models\Post::class => \App\Policies\PostPolicy::class,
        Website::class => WebsitePolicy::class,
        // Module policies are typically registered in their respective module service providers.
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        // $this->registerPolicies(); // This is usually called automatically by the parent ServiceProvider

        Gate::before(function (User $user, string $ability) {
            if ($user->hasRole('super_admin')) {
                Log::debug("[AuthServiceProvider] Gate::before - User {$user->id} is super_admin. Granting access for ability '{$ability}'.");
                return true;
            }
            Log::debug("[AuthServiceProvider] Gate::before - User {$user->id} is NOT super_admin. Boilerplate activation check REMOVED. Allowing policy check to proceed for ability '{$ability}'.");

            return null;
        });
    }
}