<?php

namespace App\Providers;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\URL; // Import the URL facade
use App\Http\View\Composers\NavigationMenuComposer;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register the View Composer for the navigation-menu view
        // This will ensure $unreadNotificationsCount is available whenever 'navigation-menu' is rendered.
        // Jetstream's navigation menu view is typically named 'navigation-menu'.
        View::composer('navigation-menu', NavigationMenuComposer::class);

        // If using ngrok or another reverse proxy that sets X-Forwarded-Proto
        // and you want to ensure all generated URLs use HTTPS.
        if (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https') {
            URL::forceScheme('https');
        }
    }
}
