<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\User; // To type-hint the notifiable user

class WelcomeUserNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     * You can add constructor parameters if you need to pass specific data
     * to the notification, e.g., a special offer code for new users.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  object  $notifiable
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        // Send via mail and store in the database by default
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  User  $notifiable  // Type-hinting $notifiable as User
     */
    public function toMail(User $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('Welcome to ' . config('app.name'))
                    ->greeting("Hello {$notifiable->name},")
                    ->line('Welcome to ' . config('app.name') . '! We are excited to have you join our community.')
                    ->line('Feel free to explore your dashboard and get started.')
                    ->action('Visit Dashboard', route('dashboard')) // Link to the user's dashboard
                    ->line('If you have any questions, don\'t hesitate to reach out to our support team.')
                    ->line('Thank you for joining!');
    }

    /**
     * Get the array representation of the notification (for database storage).
     *
     * @param  User  $notifiable // Type-hinting $notifiable as User
     * @return array<string, mixed>
     */
    public function toArray(User $notifiable): array
    {
        return [
            'greeting' => "Welcome, {$notifiable->name}!",
            'message' => 'Welcome to ' . config('app.name') . '! We are excited to have you join our community.',
            'action_text' => 'Visit Dashboard',
            'action_url' => route('dashboard'),
            'icon' => 'fas fa-handshake', // Example Font Awesome icon class
        ];
    }
}
