<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WalletWithdrawalRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'amount',
        'currency',
        'withdrawal_method',
        'payment_details',
        'status',
        'admin_notes',
        'processed_at',
        'processed_by', // Assuming you have a user who processes it
    ];

    protected $casts = [
        'payment_details' => 'array',
        'processed_at' => 'datetime',
        'amount' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function processor()
    {
        return $this->belongsTo(User::class, 'processed_by');
    }

    // Define status constants
    public const STATUS_PENDING = 'pending';
    public const STATUS_APPROVED = 'approved'; // Admin approves, ready for processing by finance/ops
    public const STATUS_PROCESSING = 'processing'; // Actively being processed
    public const STATUS_COMPLETED = 'completed'; // Funds sent
    public const STATUS_REJECTED = 'rejected';

    /**
     * Get the defined statuses for a withdrawal request.
     *
     * @return array
     */
    public static function getStatuses(): array
    {
        return [
            self::STATUS_PENDING => 'Pending',
            self::STATUS_APPROVED => 'Approved',
            self::STATUS_PROCESSING => 'Processing',
            self::STATUS_COMPLETED => 'Completed',
            self::STATUS_REJECTED => 'Rejected',
        ];
    }
}