<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class UserCreditTransaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'type',
        'credits_changed', // Changed from 'amount'
        'balance_after_transaction',
        'description',
        'related_id',
        'related_type',
    ];

    protected $casts = [
        'credits_changed' => 'integer', // Changed from 'amount'
        'balance_after_transaction' => 'integer',
    ];

    /**
     * Get the user that owns the credit transaction.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the parent related model (e.g., Subscription, Order).
     */
    public function related(): MorphTo
    {
        return $this->morphTo();
    }
}
