<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Models\Role;

class RoleSettingGroupPermission extends Model
{
    use HasFactory;

    protected $table = 'role_setting_group_permissions'; // Ensure this matches your table name

    protected $fillable = [
        'role_id',
        'setting_group_name',
        'can_view',
        'can_edit',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'can_view' => 'boolean',
        'can_edit' => 'boolean',
    ];
    /**
     * Define the relationship to the Role model.
     */
    public function role()
    {
        return $this->belongsTo(Role::class);
    }
}
