<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Newsletter extends Model
{
    use HasFactory;

    protected $fillable = [
        'subject',
        'content',
        'status',
        'sent_at',
        'scheduled_at',
        'recipients_count',
        'sent_by_user_id',
    ];

    protected $casts = [
        'sent_at' => 'datetime',
        'scheduled_at' => 'datetime',
    ];

    public function sentBy() {
        return $this->belongsTo(User::class, 'sent_by_user_id');
    }
}
