<?php

// app/Models/FeatureUsageLog.php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory; // Added

class FeatureUsageLog extends Model {
    use HasFactory; // Added

    protected $fillable = ['user_id', 'feature_key', 'credits_spent', 'details'];

    protected $casts = [
        'credits_spent' => 'integer',
        'details' => 'array', // Or 'object' if you prefer stdClass objects
    ];

    public function user() { return $this->belongsTo(User::class); }
}
