<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Models\Role; // Import Spatie's Role model

class FeatureRoleAccess extends Model
{
    use HasFactory;

    protected $table = 'feature_role_access';

    protected $fillable = [
        'feature_key',
        'role_id', // Changed from role_name
        'access_type',
        'default_limit',
    ];

    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id'); // Changed foreign key and owner key
    }
}