<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class CreditTransaction extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'credit_transactions';

    protected $fillable = [
        'user_id',
        'type', // e.g., 'award_registration', 'spend_feature_webpilotai_generate_website', 'admin_adjustment'
        'amount', // Positive for award, negative for spend
        'balance_after_transaction',
        'description',
        'related_id',
        'related_type',
    ];

    protected $casts = [
        'amount' => 'integer',
        'balance_after_transaction' => 'integer',
    ];

    /**
     * Get the user that owns the credit transaction.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the parent related model (e.g., Website, Subscription).
     */
    public function related(): MorphTo
    {
        return $this->morphTo();
    }
}