<?php

namespace App\Livewire; 

use Livewire\Component;
use Illuminate\Contracts\Auth\StatefulGuard;
use Illuminate\Support\Facades\Auth;

class UserProfileController extends Component
{
    /**
     * The state of the "Set Your Password" modal.
     *
     * @var bool
     */
    public bool $confirmingSetPassword = false;

    /**
     * The component's listeners.
     *
     * @var array
     */
    protected $listeners = [
        'password-not-set' => 'promptToSetPassword',
    ];

    /**
     * Show the "Set Your Password" modal.
     *
     * @return void
     */
    public function promptToSetPassword()
    {
        $this->confirmingSetPassword = true;
    }

    public function render()
    {
        return view('profile.show');
    }
}