<?php

namespace App\Livewire;

use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class NavigationMenu extends Component
{
    /**
     * Render the component.
     *
     * @return \Illuminate\View\View
     */
    public function render()
    {
        $unreadNotificationsCount = 0;
        if (Auth::check() && method_exists(Auth::user(), 'unreadNotifications')) {
            $unreadNotificationsCount = Auth::user()->unreadNotifications()->count();
        }

        return view('navigation-menu', compact('unreadNotificationsCount'));
    }
}