<?php

namespace App\Listeners;

use App\Events\SubscriptionSuccessfullyProcessed;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
// use App\Notifications\SubscriptionWelcomeNotification; // Example

class HandleSuccessfulSubscription // implements ShouldQueue
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  SubscriptionSuccessfullyProcessed  $event
     * @return void
     */
    public function handle(SubscriptionSuccessfullyProcessed $event)
    {
        Log::info("Subscription successfully processed for user ID: {$event->subscription->user_id}, Plan ID: {$event->subscription->subscription_plan_id}, Subscription ID: {$event->subscription->id}");

        // Example: Send a welcome email, update user roles/permissions further, etc.
        // $event->subscription->user->notify(new SubscriptionWelcomeNotification($event->subscription));
    }
}