<?php

namespace App\Http\View\Composers;

use Illuminate\View\View;
use Illuminate\Support\Facades\Auth;
use Nwidart\Modules\Facades\Module; // Ensure this is imported

class NotificationComposer
{
    public function compose(View $view)
    {
        $unreadNotificationsCount = 0;
        $recentNotifications = collect(); // Initialize as an empty collection

        // Check if the BusinessDirectory module exists and is enabled
        // And if the user is authenticated
        if (class_exists(Module::class) && Module::has('BusinessDirectory') && Module::isEnabled('BusinessDirectory')) {
            if (Auth::check()) {
                $user = Auth::user();
                // Assuming your User model has the Notifiable trait and relationships
                if (method_exists($user, 'unreadNotifications') && method_exists($user, 'notifications')) {
                    $unreadNotificationsCount = $user->unreadNotifications()->count();
                    $recentNotifications = $user->notifications()->latest()->take(5)->get();
                }
            }
        }

        $view->with('unreadNotificationsCount', $unreadNotificationsCount)
             ->with('recentNotifications', $recentNotifications);
    }
}
