<?php

namespace App\Http\View\Composers;
use Illuminate\Support\Collection;

use Illuminate\View\View;
use Illuminate\Support\Facades\Auth;

class NavigationMenuComposer
{
    /**
     * Bind data to the view.
     *
     * @param  \Illuminate\View\View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $unreadNotificationsCount = 0;
        $recentNotifications = collect(); // Initialize as an empty collection

        if (Auth::check() && method_exists(Auth::user(), 'unreadNotifications')) {
            $user = Auth::user();
            $unreadNotificationsCount = $user->unreadNotifications()->count();
            // Fetch, for example, the 5 most recent notifications
            // You might want to fetch both read and unread, or only unread depending on your UI
            $recentNotifications = $user->notifications()->latest()->take(5)->get();
        }
        $view->with('unreadNotificationsCount', $unreadNotificationsCount)
             ->with('recentNotifications', $recentNotifications);
    }
}