<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string ...$guards): Response
    {
        $guards = empty($guards) ? [null] : $guards;

        foreach ($guards as $guard) { // Typically $guard will be 'web'
            if (Auth::guard($guard)->check()) {
                $user = Auth::guard($guard)->user();
                if ($user && $user->isAdmin()) { // Use the new isAdmin() method
                    return redirect()->route('admin.dashboard');
                }
                // Default redirection for non-admin users
                return redirect(RouteServiceProvider::HOME);
            }
        }

        return $next($request);
    }
}
